/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.WindowManager;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.SessionPluginInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.GeneralSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionObjectTreePropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionSQLPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SessionPropertiesSheet
extends SessionDialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionPropertiesSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(SessionPropertiesSheet.class);
    private final List<ISessionPropertiesPanel> _panels = new ArrayList<ISessionPropertiesPanel>();
    private JTabbedPane _tabbedPane;
    private JLabel _titleLbl = new JLabel();

    public SessionPropertiesSheet(ISession session) {
        super(session.getTitle() + " " + i18n.TITLE, true, session);
        this.createGUI(session);
        for (ISessionPropertiesPanel pnl : this._panels) {
            pnl.initialize(this.getSession().getApplication(), this.getSession());
        }
        this.setSize(this.getDimension());
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt("Squirrel.newSessionPropsSheetWidth", 500), Preferences.userRoot().getInt("Squirrel.newSessionPropsSheetHeight", 600));
    }

    public void selectTabIndex(int index) {
        int tabCount = this._tabbedPane.getTabCount();
        if (0 <= index && index < tabCount) {
            this._tabbedPane.setSelectedIndex(index);
        }
    }

    @Override
    public void setTitle(String newTitle) {
        super.setTitle(newTitle);
        if (this._titleLbl != null) {
            this._titleLbl.setText(newTitle);
        }
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        boolean isDebug = s_log.isDebugEnabled();
        long start = 0L;
        for (ISessionPropertiesPanel pnl : this._panels) {
            SessionObjectTreePropertiesPanel otPanel;
            if (isDebug) {
                start = System.currentTimeMillis();
            }
            pnl.applyChanges();
            if (pnl instanceof SessionObjectTreePropertiesPanel && (otPanel = (SessionObjectTreePropertiesPanel)pnl).isObjectTreeRefreshNeeded()) {
                WindowManager wm = this.getSession().getApplication().getWindowManager();
                ISessionWidget[] frames = wm.getAllFramesOfSession(this.getSession().getIdentifier());
                for (int i = 0; i < frames.length; ++i) {
                    ISessionWidget widget = frames[i];
                    try {
                        if (!(widget instanceof SessionInternalFrame)) continue;
                        SessionInternalFrame sif = (SessionInternalFrame)widget;
                        sif.getObjectTreeAPI().refreshSelectedNodes();
                        continue;
                    }
                    catch (Exception e) {
                        s_log.error("Unexpected exception while attempting to refresh object tree: " + e.getMessage(), e);
                    }
                }
            }
            if (!isDebug) continue;
            s_log.debug("Panel " + pnl.getTitle() + " applied changes in " + (System.currentTimeMillis() - start) + "ms");
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt("Squirrel.newSessionPropsSheetWidth", size.width);
        Preferences.userRoot().putInt("Squirrel.newSessionPropsSheetHeight", size.height);
        super.dispose();
    }

    private void createGUI(ISession session) {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        IApplication app = this.getSession().getApplication();
        this._panels.add(new GeneralSessionPropertiesPanel());
        this._panels.add(new SessionObjectTreePropertiesPanel(app));
        this._panels.add(new SessionSQLPropertiesPanel(app, session));
        SessionPluginInfo[] plugins = app.getPluginManager().getPluginInformation(this.getSession());
        for (int i = 0; i < plugins.length; ++i) {
            ISessionPropertiesPanel[] pnls;
            SessionPluginInfo spi = plugins[i];
            if (!spi.isLoaded() || (pnls = spi.getSessionPlugin().getSessionPropertiesPanels(this.getSession())) == null || pnls.length <= 0) continue;
            for (int pnlIdx = 0; pnlIdx < pnls.length; ++pnlIdx) {
                this._panels.add(pnls[pnlIdx]);
            }
        }
        this._tabbedPane = UIFactory.getInstance().createTabbedPane();
        for (ISessionPropertiesPanel pnl : this._panels) {
            String pnlTitle = pnl.getTitle();
            String hint = pnl.getHint();
            this._tabbedPane.addTab(pnlTitle, null, pnl.getPanelComponent(), hint);
        }
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)this._tabbedPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionPropertiesSheet.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("sessionPropertiesSheet.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SessionPropertiesSheet.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("sessionPropertiesSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SessionPropertiesSheet.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(new JButton[]{okBtn, closeBtn});
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = SessionPropertiesSheet.access$000().getString("sessionPropertiesSheet.sessionProperties");
    }
}

