/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import sax.helpers.AttributesImpl;
import util.Arguments;

public class SAX2Writer
extends DefaultHandler {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setSchemaFullSupport = false;
    protected PrintWriter out;
    protected boolean canonical;

    protected SAX2Writer(String string, boolean bl) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, string));
        this.canonical = bl;
    }

    public SAX2Writer(boolean bl) throws UnsupportedEncodingException {
        this(null, bl);
    }

    public void characters(char[] cArray, int n, int n2) {
        this.out.print(this.normalize(new String(cArray, n, n2)));
        this.out.flush();
    }

    public void endElement(String string, String string2, String string3) {
        this.out.print("</");
        this.out.print(string3);
        this.out.print('>');
        this.out.flush();
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
        this.out.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        block18: {
            var1_1 = new Arguments();
            var1_1.setUsage(new String[]{"usage: java sax.SAX2Writer (options) uri ...", "", "options:", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=on]", "  -s | -S  Turn on/off Schema support [default=on]", "  -f | -F  Turn on/off Schema full consraint checking  [default=off]", "  -c       Canonical XML output.", "  -h       This help screen."});
            if (var0.length == 0) {
                var1_1.printUsage();
                System.exit(1);
            }
            var2_2 = false;
            var3_3 = "org.apache.xerces.parsers.SAXParser";
            var1_1.parseArgumentTokens(var0, new char[]{'p'});
            var5_4 = null;
            break block18;
            {
                switch (var4_5) {
                    case 99: {
                        var2_2 = true;
                        ** GOTO lbl48
                    }
                    case 67: {
                        var2_2 = false;
                        ** GOTO lbl48
                    }
                    case 118: {
                        SAX2Writer.setValidation = true;
                        ** GOTO lbl48
                    }
                    case 86: {
                        SAX2Writer.setValidation = false;
                        ** GOTO lbl48
                    }
                    case 78: {
                        SAX2Writer.setNameSpaces = false;
                        ** GOTO lbl48
                    }
                    case 110: {
                        SAX2Writer.setNameSpaces = true;
                        ** GOTO lbl48
                    }
                    case 112: {
                        var3_3 = var1_1.getStringParameter();
                        ** GOTO lbl48
                    }
                    case 115: {
                        SAX2Writer.setSchemaSupport = true;
                        ** GOTO lbl48
                    }
                    case 83: {
                        SAX2Writer.setSchemaSupport = false;
                        ** GOTO lbl48
                    }
                    case 102: {
                        SAX2Writer.setSchemaFullSupport = true;
                        ** GOTO lbl48
                    }
                    case 70: {
                        SAX2Writer.setSchemaFullSupport = false;
                        ** GOTO lbl48
                    }
                    case 45: 
                    case 63: 
                    case 104: {
                        var1_1.printUsage();
                        System.exit(1);
                    }
lbl48:
                    // 13 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if ((var4_5 = var1_1.getArguments()) != -1) continue block15;
                            break;
                        }
                    }
                    case -1: 
                }
            }
            System.err.println(String.valueOf(var5_4) + ':');
            SAX2Writer.print(var3_3, var5_4, var2_2);
        }
        ** while ((var5_4 = var1_1.getlistFiles()) != null)
lbl56:
        // 1 sources

    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void print(String string, String string2, boolean bl) {
        try {
            SAX2Writer sAX2Writer = new SAX2Writer(bl);
            XMLReader xMLReader = (XMLReader)Class.forName(string).newInstance();
            xMLReader.setFeature("http://xml.org/sax/features/validation", setValidation);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            xMLReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", setSchemaFullSupport);
            xMLReader.setContentHandler(sAX2Writer);
            xMLReader.setErrorHandler(sAX2Writer);
            xMLReader.parse(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void processingInstruction(String string, String string2) {
        this.out.print("<?");
        this.out.print(string);
        if (string2 != null && string2.length() > 0) {
            this.out.print(' ');
            this.out.print(string2);
        }
        this.out.print("?>");
        this.out.flush();
    }

    protected Attributes sortAttributes(Attributes attributes) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            int n3 = attributesImpl.getLength();
            int n4 = 0;
            while (n4 < n3) {
                if (string.compareTo(attributesImpl.getQName(n4)) < 0) break;
                ++n4;
            }
            attributesImpl.insertAttributeAt(n4, string, attributes.getType(n2), attributes.getValue(n2));
            ++n2;
        }
        return attributesImpl;
    }

    public void startDocument() {
        if (!this.canonical) {
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.out.flush();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.out.print('<');
        this.out.print(string3);
        if (attributes != null) {
            attributes = this.sortAttributes(attributes);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.out.print(' ');
                this.out.print(attributes.getQName(n2));
                this.out.print("=\"");
                this.out.print(this.normalize(attributes.getValue(n2)));
                this.out.print('\"');
                ++n2;
            }
        }
        this.out.print('>');
        this.out.flush();
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }
}

