/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Arrays;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public abstract class WrappedSharedCloseable
extends SharedCloseableImpl {
    final AutoCloseable[] wrapped;

    public WrappedSharedCloseable(AutoCloseable closeable) {
        this(new AutoCloseable[]{closeable});
    }

    public WrappedSharedCloseable(final AutoCloseable[] closeable) {
        super(new RefCounted.Tidy(){

            @Override
            public void tidy() throws Exception {
                for (AutoCloseable c : closeable) {
                    c.close();
                }
            }

            @Override
            public String name() {
                return Arrays.toString(closeable);
            }
        });
        this.wrapped = closeable;
    }

    protected WrappedSharedCloseable(WrappedSharedCloseable copy) {
        super(copy);
        this.wrapped = copy.wrapped;
    }
}

