/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.ParameterCache;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.SecurityProviderConstants;

final class P11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private int keySize;
    private AlgorithmParameterSpec params;
    private BigInteger rsaPublicExponent = RSAKeyGenParameterSpec.F4;
    private final int minKeySize;
    private final int maxKeySize;
    private SecureRandom random;

    P11KeyPairGenerator(Token token, String string, long l) throws PKCS11Exception {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        try {
            CK_MECHANISM_INFO cK_MECHANISM_INFO = token.getMechanismInfo(l);
            if (cK_MECHANISM_INFO != null) {
                n = cK_MECHANISM_INFO.iMinKeySize;
                n2 = cK_MECHANISM_INFO.iMaxKeySize;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Unexpected error while getting mechanism info", pKCS11Exception);
        }
        if (string.equals("EC")) {
            this.keySize = SecurityProviderConstants.DEF_EC_KEY_SIZE;
            if (n < 112) {
                n = 112;
            }
            if (n2 > 2048) {
                n2 = 2048;
            }
        } else {
            if (string.equals("DSA")) {
                this.keySize = SecurityProviderConstants.DEF_DSA_KEY_SIZE;
            } else if (string.equals("RSA")) {
                this.keySize = SecurityProviderConstants.DEF_RSA_KEY_SIZE;
                if (n2 > 65536) {
                    n2 = 65536;
                }
            } else {
                this.keySize = SecurityProviderConstants.DEF_DH_KEY_SIZE;
            }
            if (n < 512) {
                n = 512;
            }
        }
        if (this.keySize < n) {
            this.keySize = n;
        }
        if (this.keySize > n2) {
            this.keySize = n2;
        }
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        this.minKeySize = n;
        this.maxKeySize = n2;
        this.initialize(this.keySize, null);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.token.ensureValid();
        try {
            this.checkKeySize(n, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
        this.params = null;
        if (this.algorithm.equals("EC")) {
            this.params = P11ECKeyFactory.getECParameterSpec(n);
            if (this.params == null) {
                throw new InvalidParameterException("No EC parameters available for key size " + n + " bits");
            }
        }
        this.keySize = n;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        int n;
        this.token.ensureValid();
        if (this.algorithm.equals("DH")) {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DHParameterSpec required for Diffie-Hellman");
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            n = dHParameterSpec.getP().bitLength();
            this.checkKeySize(n, dHParameterSpec);
        } else if (this.algorithm.equals("RSA")) {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RSAKeyGenParameterSpec required for RSA");
            }
            RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
            n = rSAKeyGenParameterSpec.getKeysize();
            this.checkKeySize(n, rSAKeyGenParameterSpec);
            algorithmParameterSpec = null;
            this.rsaPublicExponent = rSAKeyGenParameterSpec.getPublicExponent();
        } else if (this.algorithm.equals("DSA")) {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DSAParameterSpec required for DSA");
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
            n = dSAParameterSpec.getP().bitLength();
            this.checkKeySize(n, dSAParameterSpec);
        } else if (this.algorithm.equals("EC")) {
            ECParameterSpec eCParameterSpec;
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = P11ECKeyFactory.getECParameterSpec((ECParameterSpec)algorithmParameterSpec);
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameterSpec);
                }
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                eCParameterSpec = P11ECKeyFactory.getECParameterSpec(string);
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("Unknown curve name: " + string);
                }
                algorithmParameterSpec = eCParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
            }
            n = eCParameterSpec.getCurve().getField().getFieldSize();
            this.checkKeySize(n, eCParameterSpec);
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        this.keySize = n;
        this.params = algorithmParameterSpec;
        this.random = secureRandom;
    }

    private void checkKeySize(int n, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (n <= 0) {
            throw new InvalidAlgorithmParameterException("key size must be positive, got " + n);
        }
        if (n < this.minKeySize) {
            throw new InvalidAlgorithmParameterException(this.algorithm + " key must be at least " + this.minKeySize + " bits. The specific key size " + n + " is not supported");
        }
        if (n > this.maxKeySize) {
            throw new InvalidAlgorithmParameterException(this.algorithm + " key must be at most " + this.maxKeySize + " bits. The specific key size " + n + " is not supported");
        }
        if (this.algorithm.equals("EC")) {
            if (n < 112) {
                throw new InvalidAlgorithmParameterException("EC key size must be at least 112 bit. The specific key size " + n + " is not supported");
            }
            if (n > 2048) {
                throw new InvalidAlgorithmParameterException("EC key size must be at most 2048 bit. The specific key size " + n + " is not supported");
            }
        } else {
            if (n < 512) {
                throw new InvalidAlgorithmParameterException(this.algorithm + " key size must be at least 512 bit. The specific key size " + n + " is not supported");
            }
            if (this.algorithm.equals("RSA")) {
                BigInteger bigInteger = this.rsaPublicExponent;
                if (algorithmParameterSpec != null) {
                    bigInteger = ((RSAKeyGenParameterSpec)algorithmParameterSpec).getPublicExponent();
                }
                try {
                    RSAKeyFactory.checkKeyLengths(n, bigInteger, this.minKeySize, this.maxKeySize);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException(invalidKeyException);
                }
            } else if (this.algorithm.equals("DH")) {
                if (algorithmParameterSpec != null) {
                    if (n > 65536) {
                        throw new InvalidAlgorithmParameterException("DH key size must be at most 65536 bit. The specific key size " + n + " is not supported");
                    }
                } else {
                    if (n > 8192 || n < 512 || (n & 0x3F) != 0) {
                        throw new InvalidAlgorithmParameterException("DH key size must be multiple of 64, and can only range from 512 to 8192 (inclusive). The specific key size " + n + " is not supported");
                    }
                    DHParameterSpec dHParameterSpec = ParameterCache.getCachedDHParameterSpec(n);
                    if (dHParameterSpec == null && n > 1024) {
                        throw new InvalidAlgorithmParameterException("Unsupported " + n + "-bit DH parameter generation");
                    }
                }
            } else if (n != 3072 && n != 2048 && (n > 1024 || (n & 0x3F) != 0)) {
                throw new InvalidAlgorithmParameterException("DSA key must be multiples of 64 if less than 1024 bits, or 2048, 3072 bits. The specific key size " + n + " is not supported");
            }
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2;
        long l;
        this.token.ensureValid();
        if (this.algorithm.equals("RSA")) {
            l = 0L;
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L, this.keySize), new CK_ATTRIBUTE(290L, this.rsaPublicExponent)};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DSA")) {
            l = 1L;
            if (this.params == null) {
                try {
                    object = ParameterCache.getDSAParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DSA parameters", generalSecurityException);
                }
            } else {
                object = (DSAParameterSpec)this.params;
            }
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DSAParameterSpec)object).getP()), new CK_ATTRIBUTE(305L, ((DSAParameterSpec)object).getQ()), new CK_ATTRIBUTE(306L, ((DSAParameterSpec)object).getG())};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else if (this.algorithm.equals("DH")) {
            int n;
            l = 2L;
            if (this.params == null) {
                try {
                    object = ParameterCache.getDHParameterSpec(this.keySize, this.random);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new ProviderException("Could not generate DH parameters", generalSecurityException);
                }
                n = 0;
            } else {
                object = (DHParameterSpec)this.params;
                n = ((DHParameterSpec)object).getL();
            }
            if (n <= 0) {
                n = this.keySize >= 1024 ? 768 : 512;
            }
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L, ((DHParameterSpec)object).getP()), new CK_ATTRIBUTE(306L, ((DHParameterSpec)object).getG())};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(352L, n)};
        } else if (this.algorithm.equals("EC")) {
            l = 3L;
            object = P11ECKeyFactory.encodeParameters((ECParameterSpec)this.params);
            cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L, object)};
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{};
        } else {
            throw new ProviderException("Unknown algorithm: " + this.algorithm);
        }
        object = null;
        try {
            object = this.token.getObjSession();
            cK_ATTRIBUTEArray2 = this.token.getAttributes("generate", 2L, l, cK_ATTRIBUTEArray2);
            cK_ATTRIBUTEArray = this.token.getAttributes("generate", 3L, l, cK_ATTRIBUTEArray);
            long[] lArray = this.token.p11.C_GenerateKeyPair(((Session)object).id(), new CK_MECHANISM(this.mechanism), cK_ATTRIBUTEArray2, cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey((Session)object, lArray[0], this.algorithm, this.keySize, cK_ATTRIBUTEArray2);
            PrivateKey privateKey = P11Key.privateKey((Session)object, lArray[1], this.algorithm, this.keySize, cK_ATTRIBUTEArray);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.token.releaseSession((Session)object);
        }
    }
}

