/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentUndoProvider
implements Disposable {
    private static final Key<Boolean> UNDOING_EDITOR_CHANGE = Key.create((String)"DocumentUndoProvider.UNDOING_EDITOR_CHANGE");
    private final Project myProject;

    DocumentUndoProvider(Project project) {
        MyEditorDocumentListener documentListener = new MyEditorDocumentListener();
        this.myProject = project;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this);
    }

    public void dispose() {
    }

    private UndoManagerImpl getUndoManager() {
        return (UndoManagerImpl)(this.myProject == null ? UndoManager.getGlobalInstance() : UndoManager.getInstance((Project)this.myProject));
    }

    public static void startDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, (Object)Boolean.TRUE);
        }
    }

    public static void finishDocumentUndo(@Nullable Document doc) {
        if (doc != null) {
            doc.putUserData(UNDOING_EDITOR_CHANGE, null);
        }
    }

    private class MyEditorDocumentListener
    implements DocumentListener {
        private MyEditorDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Document document;
            if (e == null) {
                MyEditorDocumentListener.$$$reportNull$$$0(0);
            }
            if (!this.shouldProcess(document = e.getDocument())) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document) && (undoManager.isUndoInProgress() || undoManager.isRedoInProgress()) && document.getUserData(UNDOING_EDITOR_CHANGE) != Boolean.TRUE) {
                throw new IllegalStateException("Do not change documents during undo as it will break undo sequence.");
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Document document;
            if (e == null) {
                MyEditorDocumentListener.$$$reportNull$$$0(1);
            }
            if (!this.shouldProcess(document = e.getDocument())) {
                return;
            }
            UndoManagerImpl undoManager = DocumentUndoProvider.this.getUndoManager();
            if (undoManager.isActive() && this.isUndoable(document)) {
                this.registerUndoableAction(e);
            } else {
                this.registerNonUndoableAction(document);
            }
        }

        private boolean shouldProcess(Document document) {
            if (DocumentUndoProvider.this.myProject != null && DocumentUndoProvider.this.myProject.isDisposed()) {
                return false;
            }
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return false;
            }
            return !UndoManagerImpl.isCopy(document) && this.shouldRecordActions(document);
        }

        private boolean shouldRecordActions(Document document) {
            if (document.getUserData(UndoConstants.DONT_RECORD_UNDO) == Boolean.TRUE) {
                return false;
            }
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(document);
            if (vFile == null) {
                return true;
            }
            return vFile.getUserData(AbstractFileViewProvider.FREE_THREADED) != Boolean.TRUE && vFile.getUserData(UndoConstants.DONT_RECORD_UNDO) != Boolean.TRUE;
        }

        private void registerUndoableAction(DocumentEvent e) {
            DocumentUndoProvider.this.getUndoManager().undoableActionPerformed((UndoableAction)new EditorChangeAction(e));
        }

        private void registerNonUndoableAction(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            DocumentUndoProvider.this.getUndoManager().nonundoableActionPerformed(ref, false);
        }

        private boolean isUndoable(Document document) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            VirtualFile file2 = ref.getFile();
            if (file2 != null && file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE) {
                return true;
            }
            return !UndoManagerImpl.isRefresh() || DocumentUndoProvider.this.getUndoManager().isUndoOrRedoAvailable(ref);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/command/impl/DocumentUndoProvider$MyEditorDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

