/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler");

    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer) {
        HashSet<String> names = new HashSet<String>();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile) {
                PsiFile file2 = (PsiFile)element;
                String name = file2.getName();
                if (names.contains(name)) {
                    return false;
                }
                names.add(name);
                continue;
            }
            if (element instanceof PsiDirectory) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget(targetElement);
    }

    public static boolean isValidTarget(PsiElement psiElement) {
        if (psiElement == null) {
            return true;
        }
        if (!(psiElement instanceof PsiDirectory) && !(psiElement instanceof PsiDirectoryContainer)) {
            return false;
        }
        if (psiElement.getManager().isInProject(psiElement)) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        return ScratchFileService.isInScratchRoot((VirtualFile)virtualFile) || virtualFile != null && ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().isExcluded(virtualFile);
    }

    public void doMove(PsiElement[] elements, PsiElement targetContainer) {
        Project project = targetContainer != null ? targetContainer.getProject() : elements[0].getProject();
        this.doMove(project, elements, targetContainer, null);
    }

    @Override
    @Nullable
    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return PsiTreeUtil.filterAncestors((PsiElement[])sourceElements);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, @Nullable MoveCallback callback2) {
        if (!LOG.assertTrue(targetContainer == null || targetContainer instanceof PsiDirectory || targetContainer instanceof PsiDirectoryContainer, (Object)("container: " + targetContainer + "; elements: " + Arrays.toString(elements) + "; working handler: " + this.toString()))) {
            return;
        }
        PsiElement[] adjustedElements = this.adjustForMove(project, elements, targetContainer);
        if (adjustedElements != null) {
            MoveFilesOrDirectoriesUtil.doMove(project, adjustedElements, new PsiElement[]{targetContainer}, callback2);
        }
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference2, Editor editor) {
        if (element instanceof PsiFile && ((PsiFile)element).getVirtualFile() != null || element instanceof PsiDirectory) {
            this.doMove(project, new PsiElement[]{element}, (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext), null);
            return true;
        }
        if (element instanceof PsiPlainText) {
            PsiFile file2 = element.getContainingFile();
            if (file2 != null) {
                this.doMove(project, new PsiElement[]{file2}, null, null);
            }
            return true;
        }
        return false;
    }
}

