/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.phpspec.PhpSpecBundle;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecUtil {
    public static final String GROUP_ID = PhpSpecBundle.message("phpspec.configurable.component.display.name", new Object[0]);
    public static final String SPEC_SUFFIX = "Spec";
    private static final String LET = "let";
    private static final String IT_PREFIX = "it_";
    private static final String ITS_PREFIX = "its_";
    public static final String PHPSPEC_RUNNER = "phpspec.php";

    public static boolean isSpecTestMethod(@NotNull Method method) {
        String name;
        if (method == null) {
            PhpSpecUtil.$$$reportNull$$$0(0);
        }
        return StringUtil.isNotEmpty((String)(name = method.getName())) && name.startsWith(IT_PREFIX) || name.startsWith(ITS_PREFIX);
    }

    public static boolean isSpecMethod(@NotNull Method method) {
        if (method == null) {
            PhpSpecUtil.$$$reportNull$$$0(1);
        }
        return PhpSpecUtil.isSpecTestMethod(method) || PhpLangUtil.equalsMethodNames((CharSequence)method.getName(), (CharSequence)LET);
    }

    public static boolean isSpecTestClass(@NotNull Project project, @NotNull String fqn) {
        String name;
        if (project == null) {
            PhpSpecUtil.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            PhpSpecUtil.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(name = PhpLangUtil.toShortName((String)fqn))) || !name.endsWith(SPEC_SUFFIX)) {
            return false;
        }
        String namespaceName = PhpLangUtil.toName((String)PhpLangUtil.getParentQualifiedName((String)fqn));
        return PhpSpecUtil.findMatchingPrefix(project, namespaceName) != null;
    }

    @NotNull
    public static String toMockedClass(@NotNull Project project, @NotNull String specClass) {
        String specClassName;
        String prefix;
        if (project == null) {
            PhpSpecUtil.$$$reportNull$$$0(4);
        }
        if (specClass == null) {
            PhpSpecUtil.$$$reportNull$$$0(5);
        }
        String string = PhpLangUtil.toFQN((String)StringUtil.trimEnd((String)((prefix = PhpSpecUtil.findMatchingPrefix(project, specClassName = PhpLangUtil.toName((String)specClass))) == null ? specClassName : StringUtil.trimStart((String)specClassName, (String)prefix)), (String)SPEC_SUFFIX));
        if (string == null) {
            PhpSpecUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static String findMatchingPrefix(@NotNull Project project, @NotNull String namespaceName) {
        if (project == null) {
            PhpSpecUtil.$$$reportNull$$$0(7);
        }
        if (namespaceName == null) {
            PhpSpecUtil.$$$reportNull$$$0(8);
        }
        int length = namespaceName.length();
        for (String prefix : PhpSpecSettingsManager.getInstance(project).getPrefixes()) {
            if (!namespaceName.startsWith(prefix) || length != prefix.length() && namespaceName.charAt(prefix.length()) != '\\') continue;
            return prefix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toMockedClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSpecTestMethod";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSpecMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSpecTestClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toMockedClass";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

