/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.ThrowableRunnable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.ParameterDef;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateCursor;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSeance;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSession;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0005\u001f !\"#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J+\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade;", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateFacade;", "delegate", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateFacade;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "openedSessions", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lkotlin/collections/ArrayList;", "connect", "", "disconnect", "getConnectionInfo", "Lorg/jetbrains/dekaf/core/ConnectionInfo;", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isConnected", "", "openSession", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSession;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "reconnect", "Companion", "Cursor", "OneTimeInvocation", "Seance", "Session", "intellij.database.dialects"})
public final class AuditFacade
implements PrimeIntermediateFacade {
    private final ArrayList<Session> openedSessions;
    private final PrimeIntermediateFacade delegate;
    @NotNull
    private final DatabaseConnection connection;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PrimeIntermediateSession openSession() {
        PrimeIntermediateSession primeIntermediateSession = this.delegate.openSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)primeIntermediateSession, (String)"delegate.openSession()");
        Session opened2 = new Session(primeIntermediateSession, this.connection, (Function1<? super Session, Unit>)((Function1)new Function1<Session, Unit>(this){
            final /* synthetic */ AuditFacade this$0;

            public final void invoke(@NotNull Session it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Collection collection = AuditFacade.access$getOpenedSessions$p(this.this$0);
                collection.remove(it);
            }
            {
                this.this$0 = auditFacade;
                super(1);
            }
        }));
        Collection collection = this.openedSessions;
        collection.add(opened2);
        return opened2;
    }

    @NotNull
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo connectionInfo = this.delegate.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionInfo, (String)"delegate.connectionInfo");
        return connectionInfo;
    }

    public void reconnect() {
        this.delegate.reconnect();
    }

    public void disconnect() {
        for (Session openedSession : this.openedSessions) {
            openedSession.disconnect();
        }
        this.openedSessions.clear();
        this.delegate.disconnect();
    }

    public void connect() {
        this.delegate.connect();
    }

    @NotNull
    public Rdbms rdbms() {
        Rdbms rdbms = this.delegate.rdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"delegate.rdbms()");
        return rdbms;
    }

    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        return (I)this.delegate.getSpecificService(serviceClass, serviceName);
    }

    @NotNull
    public final DatabaseConnection getConnection() {
        return this.connection;
    }

    public AuditFacade(@NotNull PrimeIntermediateFacade delegate, @NotNull DatabaseConnection connection2) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        this.delegate = delegate;
        this.connection = connection2;
        this.openedSessions = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getOpenedSessions$p(AuditFacade $this) {
        return $this.openedSessions;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0006\u0010\u0012\u001a\u00020\u0007J+\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J)\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\u0012\u0010 \u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSession;", "delegate", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "disposalCallback", "Lkotlin/Function1;", "", "(Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSession;Lcom/intellij/database/dataSource/DatabaseConnection;Lkotlin/jvm/functions/Function1;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnection;", "openedSeances", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lkotlin/collections/ArrayList;", "beginTransaction", "close", "commit", "disconnect", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "isClosed", "", "isInTransaction", "openSeance", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSeance;", "statementText", "outParameters", "", "Lorg/jetbrains/dekaf/core/ParameterDef;", "(Ljava/lang/String;[Lorg/jetbrains/dekaf/core/ParameterDef;)Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSeance;", "ping", "", "rollback", "intellij.database.dialects"})
    private static final class Session
    implements PrimeIntermediateSession {
        private final ArrayList<Seance> openedSeances;
        private final PrimeIntermediateSession delegate;
        @NotNull
        private final DatabaseConnection connection;
        private final Function1<Session, Unit> disposalCallback;

        @NotNull
        public PrimeIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameters) {
            Intrinsics.checkParameterIsNotNull((Object)statementText, (String)"statementText");
            PrimeIntermediateSeance primeIntermediateSeance = this.delegate.openSeance(statementText, outParameters);
            Intrinsics.checkExpressionValueIsNotNull((Object)primeIntermediateSeance, (String)"delegate.openSeance(statementText, outParameters)");
            Seance seance2 = new Seance(primeIntermediateSeance, this, statementText, (Function1<? super Seance, Unit>)((Function1)new Function1<Seance, Unit>(this){
                final /* synthetic */ Session this$0;

                public final void invoke(@NotNull Seance it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Collection collection = Session.access$getOpenedSeances$p(this.this$0);
                    collection.remove(it);
                }
                {
                    this.this$0 = session2;
                    super(1);
                }
            }));
            Collection collection = this.openedSeances;
            collection.add(seance2);
            return seance2;
        }

        public boolean isInTransaction() {
            return this.delegate.isInTransaction();
        }

        public void rollback() {
            this.delegate.rollback();
        }

        public void commit() {
            this.delegate.commit();
        }

        public void beginTransaction() {
            this.delegate.beginTransaction();
        }

        public long ping() {
            return this.delegate.ping();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            return (I)this.delegate.getSpecificService(serviceClass, serviceName);
        }

        public final void disconnect() {
            for (Seance openedSeance : this.openedSeances) {
                openedSeance.disconnect();
            }
            this.openedSeances.clear();
        }

        @NotNull
        public final DatabaseConnection getConnection() {
            return this.connection;
        }

        public Session(@NotNull PrimeIntermediateSession delegate, @NotNull DatabaseConnection connection2, @NotNull Function1<? super Session, Unit> disposalCallback) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            Intrinsics.checkParameterIsNotNull(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.connection = connection2;
            this.disposalCallback = disposalCallback;
            this.openedSeances = new ArrayList();
        }

        @NotNull
        public static final /* synthetic */ ArrayList access$getOpenedSeances$p(Session $this) {
            return $this.openedSeances;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\f\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0016J\u0006\u0010 \u001a\u00020\tJ\b\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020#H\u0016J+\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u0006\u0010(\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010)J*\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H,0/H\u0016J\u001d\u00100\u001a\u00020\t2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSeance;", "delegate", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "sql", "", "disposalCallback", "Lkotlin/Function1;", "", "(Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateSeance;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "mark", "com/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1;", "myResultSetInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "myStatementInvocation", "openedCursors", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "Lkotlin/collections/ArrayList;", "parameters", "", "", "[Ljava/lang/Object;", "resultSet", "Ljava/sql/ResultSet;", "statement", "Ljava/sql/Statement;", "before", "beforePrepared", "close", "disconnect", "execute", "getAffectedRowsCount", "", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "openCursor", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateCursor;", "R", "parameterPosition", "layout", "Lorg/jetbrains/dekaf/core/ResultLayout;", "setInParameters", "([Ljava/lang/Object;)V", "setPackLimit", "packLimit", "intellij.database.dialects"})
    private static final class Seance
    implements PrimeIntermediateSeance {
        private Object[] parameters;
        private ResultSet resultSet;
        private Statement statement;
        private OneTimeInvocation myResultSetInvocation;
        private OneTimeInvocation myStatementInvocation;
        private final mark.1 mark;
        private final ArrayList<Cursor<?>> openedCursors;
        private final PrimeIntermediateSeance delegate;
        private final Session session;
        private final String sql;
        private final Function1<Seance, Unit> disposalCallback;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <R> PrimeIntermediateCursor<R> openCursor(int parameterPosition, @NotNull ResultLayout<R> layout) {
            Intrinsics.checkParameterIsNotNull(layout, (String)"layout");
            try {
                PrimeIntermediateCursor primeIntermediateCursor = this.delegate.openCursor(parameterPosition, layout);
                Intrinsics.checkExpressionValueIsNotNull((Object)primeIntermediateCursor, (String)"delegate.openCursor(parameterPosition, layout)");
                Cursor cursor2 = new Cursor(primeIntermediateCursor, this.myResultSetInvocation, this.session, this.mark, (Function1)new Function1<Cursor<R>, Unit>(this){
                    final /* synthetic */ Seance this$0;

                    public final void invoke(@NotNull Cursor<R> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        Collection collection = Seance.access$getOpenedCursors$p(this.this$0);
                        collection.remove(it);
                    }
                    {
                        this.this$0 = seance2;
                        super(1);
                    }
                });
                Collection collection = this.openedCursors;
                collection.add(cursor2);
                collection = cursor2;
                return collection;
            }
            finally {
                if (this.resultSet != null) {
                    AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                    ResultSet resultSet = this.resultSet;
                    if (resultSet == null) {
                        Intrinsics.throwNpe();
                    }
                    advancedAuditService.resultsOpened(resultSet, this.mark);
                }
            }
        }

        public int getAffectedRowsCount() {
            return this.delegate.getAffectedRowsCount();
        }

        public void setInParameters(@NotNull Object[] parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            this.delegate.setInParameters(parameters);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        public void setPackLimit(int packLimit) {
            this.delegate.setPackLimit(packLimit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                Companion.runReporting(this.session.getConnection(), this.mark, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ Seance this$0;

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        Seance.access$before(this.this$0);
                        Seance.access$getMark$p(this.this$0).run((Function0)new Function0<Unit>(this){
                            final /* synthetic */ execute.1 this$0;

                            public final void invoke() {
                                Seance.access$getDelegate$p(this.this$0.this$0).execute();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        int count2 = this.this$0.getAffectedRowsCount();
                        if (count2 > 0) {
                            Seance.access$getSession$p(this.this$0).getConnection().getAuditService().updateCount(count2, Seance.access$getMark$p(this.this$0));
                        }
                        Seance.access$setResultSet$p(this.this$0, (ResultSet)Seance.access$getDelegate$p(this.this$0).getSpecificService(ResultSet.class, "jdbc-result-set"));
                        ResultSet resultSet = Seance.access$getResultSet$p(this.this$0);
                        if (resultSet != null) {
                            ResultSet resultSet2;
                            ResultSet it = resultSet2 = resultSet;
                            Seance.access$setMyResultSetInvocation$p(this.this$0, new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(it, this){
                                final /* synthetic */ ResultSet $it;
                                final /* synthetic */ execute.1 this$0;
                                {
                                    this.$it = resultSet;
                                    this.this$0 = var2_2;
                                    super(0);
                                }

                                public final void invoke() {
                                    Seance.access$getSession$p(this.this$0.this$0).getConnection().getAuditService().resultsProcessed(Seance.access$getMark$p(this.this$0.this$0));
                                    Seance.access$getSession$p(this.this$0.this$0).getConnection().getAuditService().beforeResultsClosing(this.$it, Seance.access$getMark$p(this.this$0.this$0));
                                }
                            })));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                    {
                        this.this$0 = seance2;
                        super(0);
                    }
                });
            }
            finally {
                this.session.getConnection().getAuditService().afterStatement(this.mark);
            }
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            return (I)this.delegate.getSpecificService(serviceClass, serviceName);
        }

        public final void disconnect() {
            block3: {
                for (Cursor<?> openedCursor : this.openedCursors) {
                    openedCursor.disconnect();
                }
                this.openedCursors.clear();
                if (this.session.isClosed()) {
                    return;
                }
                OneTimeInvocation oneTimeInvocation = this.myResultSetInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
                OneTimeInvocation oneTimeInvocation2 = this.myStatementInvocation;
                if (oneTimeInvocation2 == null) break block3;
                oneTimeInvocation2.run();
            }
        }

        private final void before() {
            if (this.parameters != null) {
                this.beforePrepared();
                return;
            }
            this.session.getConnection().getAuditService().beforeSimpleStatement(this.sql, this.mark);
        }

        private final void beforePrepared() {
            StatementParameters builder = new StatementParameters();
            if (this.parameters == null) {
                Intrinsics.throwNpe();
            }
            for (Object value : this.parameters) {
                builder.obj(value);
            }
            this.session.getConnection().getAuditService().beforeParameterizedStatement(builder.asData(this.sql), this.mark);
        }

        public Seance(@NotNull PrimeIntermediateSeance delegate, @NotNull Session session2, @NotNull String sql, @NotNull Function1<? super Seance, Unit> disposalCallback) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
            Intrinsics.checkParameterIsNotNull(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.session = session2;
            this.sql = sql;
            this.disposalCallback = disposalCallback;
            this.mark = new SmartStatementMark.RunnableMark(this){
                final /* synthetic */ Seance this$0;

                @NotNull
                public DatabaseDepartment getDepartment() {
                    return DGDepartment.INTROSPECTION;
                }

                public void cancel() {
                    if (Seance.access$getStatement$p(this.this$0) != null) {
                        JdbcNativeUtil.performSafe((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<Exception>(this){
                            final /* synthetic */ mark.1 this$0;

                            public final void run() {
                                Statement statement = Seance.access$getStatement$p(this.this$0.this$0);
                                if (statement == null) {
                                    Intrinsics.throwNpe();
                                }
                                statement.cancel();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                    }
                }
                {
                    this.this$0 = $outer;
                }
            };
            this.openedCursors = new ArrayList();
            Statement statement = this.statement = (Statement)this.delegate.getSpecificService(Statement.class, "jdbc-statement");
            if (statement != null) {
                Statement statement2;
                Statement it = statement2 = statement;
                this.myStatementInvocation = new OneTimeInvocation((Function0<Unit>)((Function0)new Function0<Unit>(it, this){
                    final /* synthetic */ Statement $it;
                    final /* synthetic */ Seance this$0;
                    {
                        this.$it = statement;
                        this.this$0 = seance2;
                        super(0);
                    }

                    public final void invoke() {
                        Seance.access$getSession$p(this.this$0).getConnection().getAuditService().beforeStatementClosing(this.$it, Seance.access$getMark$p(this.this$0));
                    }
                }));
            }
            if (this.statement != null) {
                AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                Statement statement3 = this.statement;
                if (statement3 == null) {
                    Intrinsics.throwNpe();
                }
                advancedAuditService.statementOpened(statement3, this.mark);
            }
        }

        @NotNull
        public static final /* synthetic */ ArrayList access$getOpenedCursors$p(Seance $this) {
            return $this.openedCursors;
        }

        public static final /* synthetic */ void access$before(Seance $this) {
            $this.before();
        }

        @NotNull
        public static final /* synthetic */ mark.1 access$getMark$p(Seance $this) {
            return $this.mark;
        }

        @NotNull
        public static final /* synthetic */ PrimeIntermediateSeance access$getDelegate$p(Seance $this) {
            return $this.delegate;
        }

        @NotNull
        public static final /* synthetic */ Session access$getSession$p(Seance $this) {
            return $this.session;
        }

        @Nullable
        public static final /* synthetic */ ResultSet access$getResultSet$p(Seance $this) {
            return $this.resultSet;
        }

        public static final /* synthetic */ void access$setResultSet$p(Seance $this, @Nullable ResultSet resultSet) {
            $this.resultSet = resultSet;
        }

        @Nullable
        public static final /* synthetic */ OneTimeInvocation access$getMyResultSetInvocation$p(Seance $this) {
            return $this.myResultSetInvocation;
        }

        public static final /* synthetic */ void access$setMyResultSetInvocation$p(Seance $this, @Nullable OneTimeInvocation oneTimeInvocation) {
            $this.myResultSetInvocation = oneTimeInvocation;
        }

        @Nullable
        public static final /* synthetic */ Statement access$getStatement$p(Seance $this) {
            return $this.statement;
        }

        public static final /* synthetic */ void access$setStatement$p(Seance $this, @Nullable Statement statement) {
            $this.statement = statement;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BG\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\fH\u0016J\u0006\u0010\u000f\u001a\u00020\fJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "T", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateCursor;", "delegate", "resultsClosingInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "disposalCallback", "Lkotlin/Function1;", "", "(Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateCursor;Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function1;)V", "close", "disconnect", "fetch", "()Ljava/lang/Object;", "getColumnNames", "", "", "()[Ljava/lang/String;", "hasRows", "", "setCollectLimit", "limit", "", "intellij.database.dialects"})
    private static final class Cursor<T>
    implements PrimeIntermediateCursor<T> {
        private final PrimeIntermediateCursor<T> delegate;
        private final OneTimeInvocation resultsClosingInvocation;
        private final Session session;
        private final SmartStatementMark mark;
        private final Function1<Cursor<T>, Unit> disposalCallback;

        public T fetch() {
            return (T)Companion.runReporting(this.session.getConnection(), this.mark, new Function0<T>(this){
                final /* synthetic */ Cursor this$0;

                public final T invoke() {
                    return (T)Cursor.access$getDelegate$p(this.this$0).fetch();
                }
                {
                    this.this$0 = cursor2;
                    super(0);
                }
            });
        }

        public boolean hasRows() {
            return this.delegate.hasRows();
        }

        @NotNull
        public String[] getColumnNames() {
            String[] stringArray = this.delegate.getColumnNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"delegate.columnNames");
            return stringArray;
        }

        public void setCollectLimit(int limit) {
            this.delegate.setCollectLimit(limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.delegate.close();
            }
        }

        public final void disconnect() {
            block1: {
                if (this.session.isClosed()) break block1;
                OneTimeInvocation oneTimeInvocation = this.resultsClosingInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
            }
        }

        public Cursor(@NotNull PrimeIntermediateCursor<T> delegate, @Nullable OneTimeInvocation resultsClosingInvocation, @NotNull Session session2, @NotNull SmartStatementMark mark2, @NotNull Function1<? super Cursor<T>, Unit> disposalCallback) {
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            Intrinsics.checkParameterIsNotNull(disposalCallback, (String)"disposalCallback");
            this.delegate = delegate;
            this.resultsClosingInvocation = resultsClosingInvocation;
            this.session = session2;
            this.mark = mark2;
            this.disposalCallback = disposalCallback;
        }

        @NotNull
        public static final /* synthetic */ PrimeIntermediateCursor access$getDelegate$p(Cursor $this) {
            return $this.delegate;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "", "invoker", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "invoked", "", "run", "intellij.database.dialects"})
    private static final class OneTimeInvocation {
        private boolean invoked;
        private final Function0<Unit> invoker;

        public final void run() {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            this.invoker.invoke();
        }

        public OneTimeInvocation(@NotNull Function0<Unit> invoker) {
            Intrinsics.checkParameterIsNotNull(invoker, (String)"invoker");
            this.invoker = invoker;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Companion;", "", "()V", "runReporting", "T", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runnable", "Lkotlin/Function0;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.dialects"})
    public static final class Companion {
        private final <T> T runReporting(DatabaseConnection connection2, SmartStatementMark mark2, Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable t) {
                DatabaseConnectionPoint databaseConnectionPoint = connection2.getConnectionPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
                LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"connection.connectionPoint.dataSource");
                LocalDataSource dataSource = localDataSource;
                String string = JdbcEngine.getErrorMessage(t, dataSource.getName(), dataSource.getDbms());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JdbcEngine.getErrorMessa\u2026ce.name, dataSource.dbms)");
                String message2 = string;
                connection2.getAuditService().error(message2, mark2);
                throw t;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

