/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.dialects.cassandra.generator.producers.CassKeyProducersKt;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassandraDescriptionService;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.CassIndexColumn;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassandraDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeCassAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "describeCassFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "describeCassIndex", "index", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "describeCassKey", "key", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "describeCassRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "describeCassSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "describeCassTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "o", "describeIndex", "Lcom/intellij/database/model/DasIndex;", "describeIndexingItems", "updatePresentation", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/database/model/DasObject;", "intellij.database.dialects"})
public final class CassandraDescriptionService
extends DescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof CassKey ? this.describeCassKey((CassKey)e) : (basicElement instanceof CassTableColumn ? this.describeCassTableColumn((CassTableColumn)e) : (basicElement instanceof CassIndex ? this.describeCassIndex((CassIndex)e) : (basicElement instanceof CassFunction ? this.describeCassFunction((CassFunction)e) : (basicElement instanceof CassAggregate ? this.describeCassAggregate((CassAggregate)e) : (basicElement instanceof CassRole ? this.describeCassRole((CassRole)e) : (basicElement instanceof CassSchema ? this.describeCassSchema((CassSchema)e) : super.content(e, context)))))));
    }

    private final String describeCassSchema(CassSchema e) {
        String desc = super.describeBasicElement(e) + " durable_writes: " + e.isDurableWrites();
        if (e.getReplication() != null) {
            desc = desc + " replication: " + e.getReplication();
        }
        return desc;
    }

    private final String describeCassRole(CassRole e) {
        String desc = "";
        if (e.isSuperRole()) {
            desc = desc + " superuser";
        }
        if (e.isCanLogin()) {
            desc = desc + " login";
        }
        return desc;
    }

    private final String describeCassAggregate(CassAggregate e) {
        String description = super.describeRoutine(e) + " state_type: " + e.getStateType();
        if (e.getStateFunc() != null) {
            description = description + " state_func: " + e.getStateFunc();
        }
        if (e.getFinalFunc() != null) {
            description = description + " final_func: " + e.getFinalFunc();
        }
        if (e.getInitCond() != null) {
            description = description + " init_cond: " + e.getInitCond();
        }
        return description;
    }

    private final String describeCassFunction(CassFunction e) {
        String description = super.describeRoutine(e);
        if (e.getLanguage() != null) {
            description = description + " language: " + e.getLanguage();
        }
        return description + " called_on_null_input: " + e.isCalledOnNullInput();
    }

    private final String describeCassTableColumn(CassTableColumn e) {
        String description = this.describeTableOrViewColumn(e);
        if (e.isStaticColumn()) {
            return description + " static";
        }
        return description;
    }

    private final String describeCassKey(CassKey key2) {
        String res2 = '(' + CassKeyProducersKt.describeKey(key2, (Function1<? super String, String>)((Function1)describeCassKey.res.1.INSTANCE)) + ')';
        if (CassKeyProducersKt.isDefaultClusteringOrder(key2)) {
            return res2;
        }
        return res2 + " clustering order by (" + CassKeyProducersKt.getClusteringOrderBy(key2, (Function1<? super String, String>)((Function1)describeCassKey.1.INSTANCE)) + ')';
    }

    private final String describeCassIndex(CassIndex index2) {
        String inner = this.describeIndexingItems(index2);
        return (index2.isCustom() ? "custom index" : "index") + " (" + inner + ')';
    }

    private final String describeIndexingItems(CassIndex index2) {
        String string;
        if (index2.getColumns().isEmpty()) {
            string = "???";
        } else {
            List<CassIndexColumn> list = index2.getColumns();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"index.columns");
            string = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        }
        return string;
    }

    @Override
    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull PresentationData presentation) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (dasObject instanceof CassKey) {
            this.describeCassKey(presentation, (CassKey)o);
        } else if (dasObject instanceof CassTableColumn) {
            this.describeCassTableColumn(presentation, (CassTableColumn)o);
        } else {
            super.updatePresentation(project, o, presentation);
        }
    }

    private final void describeCassKey(PresentationData presentation, CassKey key2) {
        presentation.addText(" " + this.describeCassKey(key2), DbNodeDescriptor.getGrayAttrs());
    }

    private final void describeCassTableColumn(PresentationData presentation, CassTableColumn o) {
        super.describeColumn(presentation, o);
        if (o.isStaticColumn()) {
            presentation.addText(" static", DbNodeDescriptor.getGrayAttrs());
        }
    }

    @Override
    protected void describeIndex(@NotNull PresentationData presentation, @NotNull DasIndex o) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        if (!(o instanceof CassIndex)) {
            return;
        }
        List<CassIndexColumn> list = ((CassIndex)o).getColumns();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"o.columns");
        String columns = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        presentation.addText(" (" + columns + ')', DbNodeDescriptor.getGrayAttrs());
    }
}

