/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.sybase.generator.SybaseNamingService;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseModArgument;
import com.intellij.database.dialects.sybase.model.AseModForeignKey;
import com.intellij.database.dialects.sybase.model.AseModLikeTable;
import com.intellij.database.dialects.sybase.model.AseModMajorObject;
import com.intellij.database.dialects.sybase.model.AseModSchema;
import com.intellij.database.dialects.sybase.model.AseModTable;
import com.intellij.database.dialects.sybase.model.AseModTableColumn;
import com.intellij.database.dialects.sybase.model.AseModTrigger;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u001a\u0010#\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020\u0003H\u0002\u001a\u0018\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0003H\u0002\u001a\u001e\u0010)\u001a\u0004\u0018\u00010\u00022\b\u0010*\u001a\u0004\u0018\u00010\u00022\b\u0010+\u001a\u0004\u0018\u00010\u0002H\u0002\u001a:\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u000203H\u0002\u001a\u0018\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0003H\u0000\u001a\u0016\u00108\u001a\u00020\u0017*\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0002\u001a\u001c\u0010<\u001a\u00020=*\n\u0012\u0006\b\u0001\u0012\u00020=0>2\u0006\u0010$\u001a\u00020\u0002H\u0002\u001a\u0016\u0010?\u001a\u0004\u0018\u00010\u0019*\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0002\u001a\u0016\u0010B\u001a\u0004\u0018\u00010C*\u00020@2\u0006\u0010A\u001a\u00020\u0003H\u0002\u001a\u001e\u0010D\u001a\u0004\u0018\u00010E*\u00020@2\u0006\u0010F\u001a\u00020G2\u0006\u0010%\u001a\u00020\u0003H\u0002\u001a\u0014\u0010H\u001a\u00020\u0017*\n\u0012\u0006\b\u0001\u0012\u00020I0>H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"CHARACTER_TYPES", "", "", "", "CHARACTER_TYPES_16", "COLUMN_BITS1_IDENTITY", "", "COLUMN_BITS1_NULLABLE", "COLUMN_BITS2_COMPUTED", "COLUMN_BITS2_OUTPUT", "EXACT_LENGTH_TYPES", "", "INDEX_BITS1_CLUSTERED", "INDEX_BITS1_PRIMARY", "INDEX_BITS1_UNIQUE", "INDEX_BITS2_KEY", "INDEX_BITS2_NAME_SURROGATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SYBASE_INTERNAL_REMARK_PATTERN", "Lkotlin/text/Regex;", "TYPE_SUBSTITUTION", "assignForeignKeyColumns", "", "foreignKey", "Lcom/intellij/database/dialects/sybase/model/AseModForeignKey;", "columnPositions", "", "canCheckOutdated", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "catalogPrefix", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "detectSurrogateName", "name", "id", "fixFloatPrecision", "type_name", "length", "joinSourceTextParts", "text1", "text2", "makeDataType", "Lcom/intellij/database/model/DataType;", "typeName", "precision", "scale", "variable", "ver", "Lcom/intellij/database/util/Version;", "peek16", "array", "", "offset", "addEvent", "Lcom/intellij/database/dialects/sybase/model/AseModTrigger;", "event", "Lcom/intellij/database/model/TrigEvent;", "createOrGetByName", "Lcom/intellij/database/dialects/sybase/model/AseModArgument;", "Lcom/intellij/database/model/families/ModFamily;", "findForeignKeyById", "Lcom/intellij/database/dialects/sybase/model/AseModSchema;", "objectId", "findObjectById", "Lcom/intellij/database/dialects/sybase/model/AseModMajorObject;", "findTableOrView", "Lcom/intellij/database/dialects/sybase/model/AseModLikeTable;", "code", "", "finish", "Lcom/intellij/database/model/basic/BasicModElement;", "intellij.database.dialects"})
public final class AseIntrospectorKt {
    private static final Logger LOG;
    private static final short COLUMN_BITS1_IDENTITY = 128;
    private static final short COLUMN_BITS1_NULLABLE = 8;
    private static final short COLUMN_BITS2_COMPUTED = 16;
    private static final short COLUMN_BITS2_OUTPUT = 2;
    private static final short INDEX_BITS1_PRIMARY = 2048;
    private static final short INDEX_BITS1_CLUSTERED = 16;
    private static final short INDEX_BITS1_UNIQUE = 2;
    private static final short INDEX_BITS2_NAME_SURROGATE = 8;
    private static final short INDEX_BITS2_KEY = 2;
    private static final Set<String> EXACT_LENGTH_TYPES;
    private static final Map<String, Integer> CHARACTER_TYPES;
    private static final Map<String, Integer> CHARACTER_TYPES_16;
    private static final Map<String, String> TYPE_SUBSTITUTION;
    private static final Regex SYBASE_INTERNAL_REMARK_PATTERN;

    private static final String catalogPrefix(BasicDatabase database) {
        String string;
        if (database.isCurrent()) {
            string = "dbo";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = database.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"database.name");
            string = stringBuilder.append(SybaseNamingService.INSTANCE.enquoteName(string2)).append(".dbo").toString();
        }
        return string;
    }

    private static final boolean detectSurrogateName(String name, int id) {
        if (name == null) {
            return false;
        }
        char c2 = '_';
        String string = Integer.toString(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(id)");
        String string2 = string;
        String idStr = String.valueOf(c2) + string2;
        return name.length() > idStr.length() && StringsKt.endsWith$default((String)name, (String)idStr, (boolean)false, (int)2, null);
    }

    private static final int fixFloatPrecision(String type_name, int length) {
        if (Intrinsics.areEqual((Object)"float", (Object)type_name)) {
            if (length == 8) {
                return 22;
            }
            if (length == 4) {
                return 15;
            }
        }
        return length;
    }

    private static final DataType makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        DataType dataType;
        LengthUnit u;
        short s;
        int p2;
        Map<String, Integer> charTypes;
        if (typeName == null) {
            DataType dataType2 = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataType.UNKNOWN");
            return dataType2;
        }
        boolean exactLength = EXACT_LENGTH_TYPES.contains(typeName);
        Map<String, Integer> map = charTypes = ver.isOrGreater(new int[]{16}) ? CHARACTER_TYPES_16 : CHARACTER_TYPES;
        if (length == 0 && precision == 0 || !variable && !exactLength) {
            p2 = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        } else if (precision > 0) {
            p2 = precision;
            s = scale;
            LengthUnit lengthUnit = LengthUnit.DIGIT;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.DIGIT");
            u = lengthUnit;
        } else if (exactLength) {
            s = 0;
            Integer lenFix = charTypes.get(typeName);
            if (lenFix != null) {
                p2 = length / lenFix;
                LengthUnit lengthUnit = LengthUnit.CHAR;
                Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.CHAR");
                u = lengthUnit;
            } else {
                LengthUnit lengthUnit;
                p2 = AseIntrospectorKt.fixFloatPrecision(typeName, length);
                if (length > 0) {
                    LengthUnit lengthUnit2 = LengthUnit.BYTE;
                    lengthUnit = lengthUnit2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit2, (String)"LengthUnit.BYTE");
                } else {
                    LengthUnit lengthUnit3 = LengthUnit.NONE;
                    lengthUnit = lengthUnit3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit3, (String)"LengthUnit.NONE");
                }
                u = lengthUnit;
            }
        } else {
            p2 = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        }
        try {
            String string = TYPE_SUBSTITUTION.get(typeName);
            if (string == null) {
                string = typeName;
            }
            DataType dataType3 = DataTypeFactory.of(null, string, p2, s, u, null, false, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"DataTypeFactory.of(null,\u2026s, u, null, false, false)");
            dataType = dataType3;
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            String exceptionMessage = string;
            LOG.warn("Failed to handle data type " + typeName + " with length " + length + " precision " + precision + " scale " + scale + ": " + exceptionMessage);
            DataType dataType4 = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType4, (String)"DataType.UNKNOWN");
            dataType = dataType4;
        }
        DataType dt = dataType;
        return dt;
    }

    /*
     * WARNING - void declaration
     */
    public static final short peek16(@NotNull byte[] array, int offset) {
        void that$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        byte b1 = array[offset];
        byte b2 = array[offset + 1];
        byte by = b1;
        int n = 255;
        int n2 = (b2 & 0xFF) << 8;
        void $receiver$iv$iv = $receiver$iv;
        byte by2 = (byte)(Byte.toUnsignedInt((byte)$receiver$iv$iv) & that$iv);
        return (short)(n2 | by2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void assignForeignKeyColumns(AseModForeignKey foreignKey, short[] columnPositions) {
        AseModTable aseModTable = foreignKey.getTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)aseModTable, (String)"foreignKey.table");
        AseModTable table = aseModTable;
        int n = columnPositions.length;
        ArrayList<Object> names = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            AseModTableColumn column2 = (AseModTableColumn)table.getColumns().getByNaturalPosition(columnPositions[i2]);
            Object object = column2;
            if (object == null || (object = object.getRealName()) == null) {
            } else {
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"column?.realName ?: continue");
                Object name = object;
                names.add(name);
            }
            ++i2;
        }
        foreignKey.setColNames((List<String>)names);
    }

    private static final AseModMajorObject findObjectById(@NotNull AseModSchema $receiver, int objectId) {
        AseModMajorObject aseModMajorObject;
        AseModMajorObject aseModMajorObject2;
        AseModMajorObject aseModMajorObject3 = (AseModMajorObject)$receiver.getTables().getByObjectId(objectId);
        if (aseModMajorObject3 == null) {
            aseModMajorObject3 = aseModMajorObject2 = (AseModMajorObject)$receiver.getViews().getByObjectId(objectId);
        }
        if (aseModMajorObject3 == null) {
            aseModMajorObject2 = aseModMajorObject = (AseModMajorObject)$receiver.getFunctions().getByObjectId(objectId);
        }
        if (aseModMajorObject2 == null) {
            aseModMajorObject = (AseModMajorObject)$receiver.getProcedureGroups().getByObjectId(objectId);
        }
        return aseModMajorObject;
    }

    private static final AseModForeignKey findForeignKeyById(@NotNull AseModSchema $receiver, int objectId) {
        long id = objectId;
        Iterator iterator = $receiver.getTables().iterator();
        while (iterator.hasNext()) {
            AseModTable table;
            AseModTable aseModTable = table = (AseModTable)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)aseModTable, (String)"table");
            Iterator iterator2 = aseModTable.getForeignKeys().iterator();
            while (iterator2.hasNext()) {
                AseModForeignKey fk;
                AseModForeignKey aseModForeignKey = fk = (AseModForeignKey)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)aseModForeignKey, (String)"fk");
                if (aseModForeignKey.getObjectId() != id) continue;
                return fk;
            }
        }
        return null;
    }

    private static final AseModArgument createOrGetByName(@NotNull ModFamily<? extends AseModArgument> $receiver, String name) {
        Object v1;
        block3: {
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                AseModArgument it;
                AseModArgument aseModArgument = it = (AseModArgument)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)aseModArgument, (String)"it");
                if (!Intrinsics.areEqual((Object)aseModArgument.getName(), (Object)name)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        AseModArgument a = v1;
        if (a == null) {
            a = $receiver.createNewOne();
            a.setName(name);
        } else {
            a.resetSyncPending();
        }
        return a;
    }

    private static final void finish(@NotNull ModFamily<? extends BasicModElement> $receiver) {
        $receiver.removeSyncPendingChildren();
        $receiver.sort();
    }

    private static final void addEvent(@NotNull AseModTrigger $receiver, TrigEvent event) {
        if (event == null) {
            return;
        }
        Set<TrigEvent> set = $receiver.getEvents();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"this.events");
        Set<TrigEvent> events = set;
        if (events.isEmpty()) {
            $receiver.setEvents(Collections.singleton(event));
        } else if (!events.contains(event)) {
            $receiver.setEvents(SetsKt.plus(events, (Object)event));
        }
    }

    private static final AseModLikeTable findTableOrView(@NotNull AseModSchema $receiver, char code, int id) {
        AseModLikeTable aseModLikeTable;
        switch (code) {
            case 'T': {
                aseModLikeTable = (AseModLikeTable)$receiver.getTables().getByObjectId(id);
                break;
            }
            case 'V': {
                aseModLikeTable = (AseModLikeTable)$receiver.getViews().getByObjectId(id);
                break;
            }
            default: {
                aseModLikeTable = null;
            }
        }
        return aseModLikeTable;
    }

    private static final String joinSourceTextParts(String text1, String text2) {
        CharSequence charSequence;
        Regex regex;
        return text1 == null ? text2 : (text2 == null ? text1 : ((regex = SYBASE_INTERNAL_REMARK_PATTERN).matches(charSequence = (CharSequence)text1) && StringsKt.startsWith$default((String)text2, (String)"CREATE", (boolean)false, (int)2, null) ? text1 + '\n' + text2 : text1 + text2));
    }

    private static final boolean canCheckOutdated(BasicElement e) {
        return e instanceof AseSchemaObject && !(e instanceof AseFunction) && !(e instanceof AseProcedureGroup) && !(e instanceof AseTrigger) && ((AseSchemaObject)e).getStateNumber() != -1;
    }

    static {
        Logger logger = Logger.getInstance(BaseMultiDatabaseIntrospector.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(BaseM\u2026Introspector::class.java)");
        LOG = logger;
        EXACT_LENGTH_TYPES = SetsKt.setOf((Object[])new String[]{"char", "nchar", "unichar", "varchar", "nvarchar", "univarchar", "binary", "float", "numeric", "decimal"});
        CHARACTER_TYPES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)1), TuplesKt.to((Object)"varchar", (Object)1), TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2), TuplesKt.to((Object)"nchar", (Object)3), TuplesKt.to((Object)"nvarchar", (Object)3), TuplesKt.to((Object)"sysname", (Object)1), TuplesKt.to((Object)"longsysname", (Object)1)});
        CHARACTER_TYPES_16 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2)});
        TYPE_SUBSTITUTION = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"usmallint", (Object)"unsigned smallint"), TuplesKt.to((Object)"uint", (Object)"unsigned int"), TuplesKt.to((Object)"ubigint", (Object)"unsigned bigint")});
        String string = "^/\\*[^/]+?\\*/\\s*$";
        SYBASE_INTERNAL_REMARK_PATTERN = new Regex(string);
    }

    public static final /* synthetic */ boolean access$canCheckOutdated(@NotNull BasicElement e) {
        return AseIntrospectorKt.canCheckOutdated(e);
    }

    @NotNull
    public static final /* synthetic */ String access$catalogPrefix(@NotNull BasicDatabase database) {
        return AseIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ void access$finish(@NotNull ModFamily $receiver) {
        AseIntrospectorKt.finish($receiver);
    }

    @Nullable
    public static final /* synthetic */ AseModMajorObject access$findObjectById(@NotNull AseModSchema $receiver, int objectId) {
        return AseIntrospectorKt.findObjectById($receiver, objectId);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@Nullable String typeName, int length, short precision, short scale, boolean variable, @NotNull Version ver) {
        return AseIntrospectorKt.makeDataType(typeName, length, precision, scale, variable, ver);
    }

    @NotNull
    public static final /* synthetic */ AseModArgument access$createOrGetByName(@NotNull ModFamily $receiver, @NotNull String name) {
        return AseIntrospectorKt.createOrGetByName($receiver, name);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(@Nullable String name, int id) {
        return AseIntrospectorKt.detectSurrogateName(name, id);
    }

    public static final /* synthetic */ void access$assignForeignKeyColumns(@NotNull AseModForeignKey foreignKey, @NotNull short[] columnPositions) {
        AseIntrospectorKt.assignForeignKeyColumns(foreignKey, columnPositions);
    }

    @Nullable
    public static final /* synthetic */ AseModForeignKey access$findForeignKeyById(@NotNull AseModSchema $receiver, int objectId) {
        return AseIntrospectorKt.findForeignKeyById($receiver, objectId);
    }

    public static final /* synthetic */ void access$addEvent(@NotNull AseModTrigger $receiver, @Nullable TrigEvent event) {
        AseIntrospectorKt.addEvent($receiver, event);
    }

    @Nullable
    public static final /* synthetic */ String access$joinSourceTextParts(@Nullable String text1, @Nullable String text2) {
        return AseIntrospectorKt.joinSourceTextParts(text1, text2);
    }

    @Nullable
    public static final /* synthetic */ AseModLikeTable access$findTableOrView(@NotNull AseModSchema $receiver, char code, int id) {
        return AseIntrospectorKt.findTableOrView($receiver, code, id);
    }
}

