/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.behat;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.BehatContextRoot;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementType;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class BehatUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Behat", (String)ToolWindowId.RUN, (boolean)false);
    public static final String BEHAT_HELPER_SCRIPT_NAME = "behat.php";
    public static final String BOOTSTRAP_DIR_NAME = "bootstrap";

    @Nullable
    public static GherkinStepsHolder[] findAllScenarios(@NotNull PsiFile file) {
        GherkinFeature[] features;
        if (file == null) {
            BehatUtil.$$$reportNull$$$0(0);
        }
        if (file.getFileType() == GherkinFileType.INSTANCE && (features = (GherkinFeature[])PsiTreeUtil.getChildrenOfType((PsiElement)file, GherkinFeature.class)) != null && features.length > 0) {
            return (GherkinStepsHolder[])PsiTreeUtil.getChildrenOfType((PsiElement)features[0], GherkinStepsHolder.class);
        }
        return null;
    }

    public static int getScenarioStartLine(@NotNull Project project, @NotNull GherkinStepsHolder scenario) {
        if (project == null) {
            BehatUtil.$$$reportNull$$$0(1);
        }
        if (scenario == null) {
            BehatUtil.$$$reportNull$$$0(2);
        }
        GherkinElementType keywordToken = scenario instanceof GherkinScenarioOutline ? GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD : GherkinTokenTypes.SCENARIO_KEYWORD;
        PsiElement keyword = PhpPsiUtil.getChildOfType((PsiElement)scenario, (IElementType)keywordToken);
        GherkinStepsHolder startElement = keyword == null ? scenario : keyword;
        int offset = startElement.getTextRange().getStartOffset();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(scenario.getContainingFile());
        return document == null ? -1 : document.getLineNumber(offset) + 1;
    }

    @NotNull
    public static String getScenarioName(@NotNull GherkinStepsHolder element) {
        String scenarioName;
        if (element == null) {
            BehatUtil.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)(scenarioName = element.getScenarioName()))) {
            int line = BehatUtil.getScenarioStartLine(element.getProject(), element);
            assert (line > 0);
            String string = "Scenario on line " + line;
            if (string == null) {
                BehatUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = scenarioName;
        if (string == null) {
            BehatUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void showErrorNotification(@NotNull Project project, @NotNull String title, @NotNull String message) {
        if (project == null) {
            BehatUtil.$$$reportNull$$$0(6);
        }
        if (title == null) {
            BehatUtil.$$$reportNull$$$0(7);
        }
        if (message == null) {
            BehatUtil.$$$reportNull$$$0(8);
        }
        NOTIFICATION_GROUP.createNotification(title, message, NotificationType.ERROR, null).notify(project);
    }

    @Nullable
    public static GherkinStepsHolder findScenarioByName(@NotNull PsiFile file, @NotNull String scenarioName) {
        GherkinStepsHolder[] scenarios;
        if (file == null) {
            BehatUtil.$$$reportNull$$$0(9);
        }
        if (scenarioName == null) {
            BehatUtil.$$$reportNull$$$0(10);
        }
        if ((scenarios = BehatUtil.findAllScenarios(file)) != null) {
            for (GherkinStepsHolder scenario : scenarios) {
                if (!StringUtil.equals((CharSequence)scenarioName, (CharSequence)BehatUtil.getScenarioName(scenario))) continue;
                return scenario;
            }
        }
        return null;
    }

    @Nullable
    public static PhpClass getContextInterface(@NotNull Project project) {
        Collection oldContextInterfaces;
        if (project == null) {
            BehatUtil.$$$reportNull$$$0(11);
        }
        if (!(oldContextInterfaces = PhpIndex.getInstance((Project)project).getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE.getFqn())).isEmpty()) {
            return (PhpClass)oldContextInterfaces.iterator().next();
        }
        Collection newContextInterfaces = PhpIndex.getInstance((Project)project).getInterfacesByFQN(BehatContextRoot.CONTEXT_INTERFACE_NEW.getFqn());
        return newContextInterfaces.isEmpty() ? null : (PhpClass)newContextInterfaces.iterator().next();
    }

    public static boolean isContextClass(@Nullable PhpClass contextInterface, @NotNull PhpClass clazz) {
        if (clazz == null) {
            BehatUtil.$$$reportNull$$$0(12);
        }
        if (contextInterface == null) {
            return false;
        }
        Ref isSuperClassRef = new Ref((Object)false);
        PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)false, (boolean)false, aClass -> {
            if (aClass == contextInterface) {
                isSuperClassRef.set((Object)true);
            }
            return (Boolean)isSuperClassRef.get() == false;
        });
        return (Boolean)isSuperClassRef.get();
    }

    public static boolean isRunnableStepHolder(@NotNull GherkinStepsHolder holder) {
        if (holder == null) {
            BehatUtil.$$$reportNull$$$0(13);
        }
        return !(holder instanceof GherkinScenario) || !((GherkinScenario)holder).isBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scenario";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/behat/BehatUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scenarioName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/behat/BehatUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScenarioName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAllScenarios";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScenarioStartLine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScenarioName";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScenarioByName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContextInterface";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isContextClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isRunnableStepHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

