/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.icons.AllIcons;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;

class DiffNodeTreeCellRenderer
extends V8ProfileLineTreeCellRenderer<Object> {
    public static final int BOUND = 10;
    private Integer myBaseTicks;
    private Integer myChangedTicks;

    DiffNodeTreeCellRenderer() {
        super(node -> false, null);
    }

    public void setBaseTicks(Integer baseTicks) {
        this.myBaseTicks = baseTicks;
    }

    public void setChangedTicks(Integer changedTicks) {
        this.myChangedTicks = changedTicks;
    }

    @Override
    protected V8CpuLogCall getCall(Object object) {
        if (object instanceof ChainTreeTableModel.Node) {
            return this.getCall(((ChainTreeTableModel.Node)object).getT());
        }
        if (!(object instanceof DiffNode)) {
            return null;
        }
        return ((DiffNode)object).getCall();
    }

    @Override
    protected void markLineWithIcon(Object object) {
        DiffNode node = null;
        if (object instanceof ChainTreeTableModel.Node) {
            Object inner = ((ChainTreeTableModel.Node)object).getT();
            if (inner instanceof DiffNode) {
                node = (DiffNode)inner;
            }
        } else if (object instanceof DiffNode) {
            node = (DiffNode)object;
        }
        if (node != null) {
            if (node.isAdded() && this.changedTensPercent(node) >= 10 || this.changed(node) && this.changedTensPercent(node) - this.baseTensPercent(node) >= 10) {
                this.setIcon(AllIcons.Actions.MoveUp);
            } else if (node.isDeleted() && this.baseTensPercent(node) >= 10 || this.changed(node) && this.baseTensPercent(node) - this.changedTensPercent(node) >= 10) {
                this.setIcon(AllIcons.Actions.MoveDown);
            }
        }
    }

    private boolean changed(DiffNode node) {
        return !node.isAdded() && !node.isDeleted();
    }

    private int baseTensPercent(DiffNode node) {
        if (this.myBaseTicks != null) {
            return V8Utils.tensPercent(node.getBefore().getTotal(), this.myBaseTicks);
        }
        return V8Utils.tensPercent(node.getBefore().getTotal(), node.getBefore().getNumParentTicks());
    }

    private int changedTensPercent(DiffNode node) {
        if (this.myChangedTicks != null) {
            return V8Utils.tensPercent(node.getAfter().getTotal(), this.myChangedTicks);
        }
        return V8Utils.tensPercent(node.getAfter().getTotal(), node.getAfter().getNumParentTicks());
    }
}

