/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.renderers;

import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class SizeRenderer
extends ColoredTableCellRenderer {
    private final SimpleTextAttributes myBlackTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null);
    private final SimpleTextAttributes mySelectionAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableSelectionForeground(), null, null);
    private final long myTotalSize;

    public SizeRenderer(long size) {
        this.myTotalSize = size;
    }

    protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        SimpleTextAttributes attr;
        this.setPaintFocusBorder(false);
        this.setTextAlign(4);
        boolean lineHasFocus = table.hasFocus();
        boolean useSelection = selected && (lineHasFocus || UIUtil.isUnderDarcula());
        SimpleTextAttributes simpleTextAttributes = attr = useSelection ? this.mySelectionAttributes : this.myBlackTextAttributes;
        if (value instanceof Long) {
            this.append(SizeRenderer.formatSize(value.toString()), attr);
            this.append(" ");
            int tens = (int)Math.round(((Long)value).doubleValue() / (double)this.myTotalSize * 1000.0);
            if (tens < 100) {
                this.append(" ");
            }
            String percent = "" + tens / 10 + "." + tens % 10 + "%";
            this.append(percent, useSelection ? this.mySelectionAttributes : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else {
            this.append(value.toString(), attr);
        }
        if (!lineHasFocus && selected) {
            this.setBackground(UIUtil.getTreeUnfocusedSelectionBackground());
        }
    }

    @NotNull
    public static String formatSize(long number) {
        String string = SizeRenderer.formatSize(String.valueOf(number));
        if (string == null) {
            SizeRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String formatSize(String number) {
        if (number.length() <= 3) {
            String string = number;
            if (string == null) {
                SizeRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }
        int spaceIdx = number.length() % 3;
        spaceIdx = spaceIdx > 0 ? spaceIdx - 1 : 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            sb.append(number.charAt(i));
            if (i != spaceIdx || i == number.length() - 1) continue;
            sb.append(' ');
            spaceIdx += 3;
        }
        String string = sb.toString();
        if (string == null) {
            SizeRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/renderers/SizeRenderer", "formatSize"));
    }
}

