/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightUsagesHandlerBase;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightExceptionsHandler
extends PhpHighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;
    private final PsiElement myScope;
    private final PhpType myExceptions;
    private final PhpType myExceptionsToFilter;

    public PhpHighlightExceptionsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target, @NotNull PsiElement scope, @NotNull PhpType exceptions, @NotNull PhpType exceptionsToFilter) {
        if (editor == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(1);
        }
        if (target == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(3);
        }
        if (exceptions == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(4);
        }
        if (exceptionsToFilter == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(5);
        }
        super(editor, file);
        this.myTarget = target;
        this.myExceptions = exceptions;
        this.myExceptionsToFilter = exceptionsToFilter;
        this.myScope = scope;
    }

    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        this.addOccurrence(this.myTarget);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(this.myScope);
        if (scopeHolder != null) {
            Project project = scopeHolder.getProject();
            TextRange thrownRange = this.myScope.getTextRange();
            Set<Pair<TextRange, String>> rangeExceptions = PhpThrownExceptionsAnalyzer.getExceptionClassesWithRanges(scopeHolder, thrownRange, thrownRange, false);
            Set exceptions = StreamEx.of(rangeExceptions).map(pair -> (String)pair.second).toSet();
            Collection<String> filtered = PhpThrownExceptionsAnalyzer.filterNonThrowable(exceptions, project);
            PhpIndex index = PhpIndex.getInstance((Project)project);
            for (Pair<TextRange, String> rangException : rangeExceptions) {
                String exception = (String)rangException.second;
                if (!filtered.contains(exception) || !this.shouldHighlight(new PhpType().add(exception), index)) continue;
                this.myReadUsages.add(rangException.first);
            }
        }
    }

    private boolean shouldHighlight(@NotNull PhpType type, @NotNull PhpIndex index) {
        if (type == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(6);
        }
        if (index == null) {
            PhpHighlightExceptionsHandler.$$$reportNull$$$0(7);
        }
        return !(!this.myExceptions.isUndefined() && !this.myExceptions.isConvertibleFrom(type, index) || !this.myExceptionsToFilter.isUndefined() && this.myExceptionsToFilter.isConvertibleFrom(type, index));
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.throws";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsToFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightExceptionsHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

