/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.run.PhpRunUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExecutableMacro
extends Macro {
    public String getName() {
        return "PhpExecutable";
    }

    public String getDescription() {
        return PhpBundle.message("php.executable.macro.description", new Object[0]);
    }

    public String expand(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return PhpExecutableMacro.getPhpCommand(project);
    }

    @NotNull
    public static String getPhpCommand(@Nullable Project project) {
        if (project == null) {
            String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            if (string == null) {
                PhpExecutableMacro.$$$reportNull$$$0(0);
            }
            return string;
        }
        String phpHome = PhpProjectConfigurationFacade.getInstance(project).getPhpHome();
        if (!StringUtil.isEmpty((String)phpHome)) {
            VirtualFile binary = PhpRunUtil.findFileOrDirectory(phpHome, false);
            if (binary != null && binary.isDirectory()) {
                String string = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)phpHome), (String)File.separator) + File.separator + PhpProjectConfigurationFacade.PHP_EXECUTABLE;
                if (string == null) {
                    PhpExecutableMacro.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = FileUtil.toSystemDependentName((String)phpHome);
            if (string == null) {
                PhpExecutableMacro.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
        if (string == null) {
            PhpExecutableMacro.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/macro/PhpExecutableMacro", "getPhpCommand"));
    }
}

