/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTypeCheckingFunction<T extends Item>
implements ItemMappingFunction<T, T> {
    private ItemType requiredItemType;
    private SourceLocator locator;
    private RoleLocator role;
    private Configuration config = null;

    public ItemTypeCheckingFunction(ItemType requiredItemType, RoleLocator role, SourceLocator locator, Configuration config) {
        this.requiredItemType = requiredItemType;
        this.role = role;
        this.locator = locator;
        this.config = config;
    }

    @Override
    public T mapItem(T item) throws XPathException {
        this.testConformance(item, this.config);
        return item;
    }

    private void testConformance(T item, Configuration config) throws XPathException {
        if (!this.requiredItemType.matchesItem((Item)item, true, config)) {
            NamePool pool = config.getNamePool();
            TypeHierarchy th = config.getTypeHierarchy();
            String message = this.role.composeErrorMessage(this.requiredItemType, Type.getItemType(item, th));
            String errorCode = this.role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                XPathException te = new XPathException(message, errorCode);
                te.setLocator(this.locator);
                te.setIsTypeError(false);
                throw te;
            }
            XPathException te = new XPathException(message, errorCode);
            te.setLocator(this.locator);
            te.setIsTypeError(true);
            throw te;
        }
    }
}

