/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WindowsTimer;

public final class Stress {
    private static volatile boolean stopped = false;

    public static void main(String[] arguments) throws Exception {
        StressSettings settings;
        if (FBUtilities.isWindows()) {
            WindowsTimer.startTimerPeriod((int)1);
        }
        try {
            settings = StressSettings.parse(arguments);
        }
        catch (IllegalArgumentException e) {
            Stress.printHelpMessage();
            e.printStackTrace();
            return;
        }
        PrintStream logout = settings.log.getOutput();
        if (settings.sendToDaemon != null) {
            BufferedReader inp;
            ObjectOutputStream out;
            Socket socket;
            block10: {
                socket = new Socket(settings.sendToDaemon, 2159);
                out = new ObjectOutputStream(socket.getOutputStream());
                inp = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                Runtime.getRuntime().addShutdownHook(new ShutDown(socket, out));
                out.writeObject(settings);
                try {
                    String line;
                    while (!socket.isClosed() && (line = inp.readLine()) != null) {
                        if (line.equals("END") || line.equals("FAILURE")) {
                            out.writeInt(1);
                            break;
                        }
                        logout.println(line);
                    }
                }
                catch (SocketException e) {
                    if (stopped) break block10;
                    e.printStackTrace();
                }
            }
            out.close();
            inp.close();
            socket.close();
        } else {
            StressAction stressAction = new StressAction(settings, logout);
            stressAction.run();
        }
        if (FBUtilities.isWindows()) {
            WindowsTimer.endTimerPeriod((int)1);
        }
        System.exit(0);
    }

    public static void printHelpMessage() {
        StressSettings.printHelp();
    }

    private static class ShutDown
    extends Thread {
        private final Socket socket;
        private final ObjectOutputStream out;

        public ShutDown(Socket socket, ObjectOutputStream out) {
            this.out = out;
            this.socket = socket;
        }

        @Override
        public void run() {
            try {
                if (!this.socket.isClosed()) {
                    System.out.println("Control-C caught. Canceling running action and shutting down...");
                    this.out.writeInt(1);
                    this.out.close();
                    stopped = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

