/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.BooleanValueStream;

public class BooleanMultiField
extends AnalyticsField
implements BooleanValueStream.CastingBooleanValueStream {
    private SortedSetDocValues docValues;
    private int count = 0;
    private boolean[] values = new boolean[20];
    private int trueOrd;

    public BooleanMultiField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.fieldName);
        long numOrds = this.docValues.getValueCount();
        int trueOrd = -2;
        int i = 0;
        while ((long)i < numOrds) {
            BytesRef br = this.docValues.lookupOrd((long)i);
            if (br.length == 1 && br.bytes[br.offset] == 84) {
                trueOrd = i;
                break;
            }
            ++i;
        }
        this.trueOrd = trueOrd;
    }

    @Override
    public void collect(int doc) throws IOException {
        this.count = 0;
        if (this.docValues.advanceExact(doc)) {
            int term;
            while ((long)(term = (int)this.docValues.nextOrd()) != -1L) {
                if (this.count == this.values.length) {
                    this.resizeValues();
                }
                this.values[this.count++] = term == this.trueOrd;
            }
        }
    }

    private void resizeValues() {
        boolean[] newValues = new boolean[this.values.length * 2];
        for (int i = 0; i < this.count; ++i) {
            newValues[i] = this.values[i];
        }
        this.values = newValues;
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamBooleans(value -> cons.accept(Boolean.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamBooleans(value -> cons.accept(value));
    }
}

