/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

class StringStreamIfFunction
extends StringValueStream.AbstractStringValueStream {
    private final BooleanValue ifExpr;
    private final StringValueStream thenExpr;
    private final StringValueStream elseExpr;
    public static final String name = "if";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringStreamIfFunction(BooleanValue ifExpr, StringValueStream thenExpr, StringValueStream elseExpr) throws SolrException {
        this.ifExpr = ifExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, ifExpr, thenExpr, elseExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, ifExpr, thenExpr, elseExpr);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        boolean ifValue = this.ifExpr.getBoolean();
        if (this.ifExpr.exists()) {
            if (ifValue) {
                this.thenExpr.streamStrings(cons);
            } else {
                this.elseExpr.streamStrings(cons);
            }
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

