/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.util.TcclThreadFactory;

public class MessageDispatch15Interceptor
extends MessageDispatchInterceptor {
    protected AtomicLong currentSize = new AtomicLong(0L);
    protected ThreadPoolExecutor executor = null;
    protected int maxThreads = 10;
    protected int maxSpareThreads = 2;
    protected long keepAliveTime = 5000L;
    protected LinkedBlockingQueue<Runnable> runnablequeue = new LinkedBlockingQueue();

    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public long addAndGetCurrentSize(long inc) {
        return this.currentSize.addAndGet(inc);
    }

    public long setAndGetCurrentSize(long value) {
        this.currentSize.set(value);
        return value;
    }

    public boolean addToQueue(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        final LinkObject obj = new LinkObject(msg, destination, payload);
        Runnable r = new Runnable(){

            public void run() {
                MessageDispatch15Interceptor.this.sendAsyncData(obj);
            }
        };
        this.executor.execute(r);
        return true;
    }

    public LinkObject removeFromQueue() {
        return null;
    }

    public void startQueue() {
        if (this.run) {
            return;
        }
        this.executor = new ThreadPoolExecutor(this.maxSpareThreads, this.maxThreads, this.keepAliveTime, TimeUnit.MILLISECONDS, this.runnablequeue, new TcclThreadFactory());
        this.run = true;
    }

    public void stopQueue() {
        this.run = false;
        this.executor.shutdownNow();
        this.setAndGetCurrentSize(0L);
        this.runnablequeue.clear();
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }
}

