/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinator {
    private Combinator parent;
    private ArrayList<Combinator> children = new ArrayList();
    private LinkedHashMap<String, ComboOption> comboOptions = new LinkedHashMap();
    private int annonymousAttributeCounter;

    public Combinator() {
    }

    public Combinator(Combinator parent) {
        this.parent = parent;
    }

    public static Combinator combinator() {
        return new Combinator();
    }

    public ArrayList<Combinator> all() {
        ArrayList<Combinator> rc = new ArrayList<Combinator>();
        this.root()._all(rc);
        return rc;
    }

    private void _all(ArrayList<Combinator> rc) {
        rc.add(this);
        for (Combinator c : this.children) {
            c._all(rc);
        }
    }

    public Combinator put(String attribute, Object ... options) {
        ComboOption co = this.comboOptions.get(attribute);
        if (co == null) {
            this.comboOptions.put(attribute, new ComboOption(attribute, Arrays.asList(options)));
        } else {
            co.values.addAll(Arrays.asList(options));
        }
        return this;
    }

    public Combinator and() {
        Combinator combinator = new Combinator(this);
        this.children.add(combinator);
        return combinator;
    }

    public Combinator add(Object ... options) {
        this.put("" + this.annonymousAttributeCounter++, options);
        return this;
    }

    public Set<Map<String, Object>> combinations() {
        return this.root()._combinations();
    }

    private Combinator root() {
        Combinator c = this;
        while (c.parent != null) {
            c = c.parent;
        }
        return c;
    }

    private Set<Map<String, Object>> _combinations() {
        LinkedHashSet<Map<String, Object>> rc = new LinkedHashSet<Map<String, Object>>();
        ArrayList<Map<String, Object>> expandedOptions = new ArrayList<Map<String, Object>>();
        this.expandCombinations(new ArrayList<ComboOption>(this.comboOptions.values()), expandedOptions);
        rc.addAll(expandedOptions);
        for (Combinator c : this.children) {
            rc.addAll(c._combinations());
        }
        return rc;
    }

    private void expandCombinations(List<ComboOption> optionsLeft, List<Map<String, Object>> expandedCombos) {
        if (!optionsLeft.isEmpty()) {
            Map<Object, Object> map;
            if (this.comboOptions.size() == optionsLeft.size()) {
                map = new LinkedHashMap();
                expandedCombos.add(map);
            } else {
                map = expandedCombos.get(expandedCombos.size() - 1);
            }
            LinkedList<ComboOption> l = new LinkedList<ComboOption>(optionsLeft);
            ComboOption comboOption = l.removeFirst();
            int i = 0;
            for (Object e : comboOption.values) {
                if (i != 0) {
                    map = new LinkedHashMap(map);
                    expandedCombos.add(map);
                }
                map.put(comboOption.attribute, e);
                this.expandCombinations(l, expandedCombos);
                ++i;
            }
        }
    }

    public <T> Object[] combinationsAsBeans(Class<T> clazz) throws Exception {
        Set<Map<String, Object>> combinations = this.combinations();
        ArrayList<T> rc = new ArrayList<T>(combinations.size());
        for (Map<String, Object> combination : combinations) {
            T instance = clazz.newInstance();
            for (Map.Entry<String, Object> entry : combination.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                try {
                    Method method = clazz.getMethod("set" + Combinator.ucfc(key), value.getClass());
                    method.invoke(instance, value);
                }
                catch (Exception ignore) {
                    Field declaredField = clazz.getDeclaredField(key);
                    declaredField.set(instance, value);
                }
            }
            if (instance instanceof CombinationAware) {
                ((CombinationAware)instance).setCombination(combination);
            }
            rc.add(instance);
        }
        Object[] t = new Object[rc.size()];
        rc.toArray(t);
        return t;
    }

    public <T> Object[][] combinationsAsParameterArgBeans(Class<T> clazz) throws Exception {
        Object[] x = this.combinationsAsBeans(clazz);
        Object[][] rc = new Object[x.length][];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = new Object[]{x[i]};
        }
        return rc;
    }

    public <T> T[] asBeans(BeanFactory<T> factory) throws Exception {
        Set<Map<String, Object>> combinations = this.combinations();
        ArrayList<Object> rc = new ArrayList<Object>(combinations.size());
        Class<?> clazz = null;
        for (Map<String, Object> combination : combinations) {
            T instance = factory.createBean();
            if (clazz == null) {
                clazz = instance.getClass();
            }
            for (Map.Entry<String, Object> entry : combination.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                try {
                    Method method = clazz.getMethod("set" + Combinator.ucfc(key), value.getClass());
                    method.invoke(instance, value);
                }
                catch (Exception ignore) {
                    this.setField(clazz, instance, key, value);
                }
            }
            if (instance instanceof CombinationAware) {
                ((CombinationAware)instance).setCombination(combination);
            }
            rc.add(instance);
        }
        T[] t = this.toArray(factory, rc);
        rc.toArray(t);
        return t;
    }

    private <T> T[] toArray(BeanFactory<T> factory, List<Object> rc) {
        return (Object[])Array.newInstance(factory.getBeanClass(), rc.size());
    }

    private void setField(Class<? extends Object> clazz, Object instance, String key, Object value) throws NoSuchFieldException, IllegalAccessException {
        while (clazz != null) {
            try {
                Field declaredField = clazz.getDeclaredField(key);
                declaredField.setAccessible(true);
                declaredField.set(instance, value);
                return;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
    }

    public <T> Object[][] combinationsAsParameterArgBeans(BeanFactory<T> factory) throws Exception {
        T[] x = this.asBeans(factory);
        Object[][] rc = new Object[x.length][];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = new Object[]{x[i]};
        }
        return rc;
    }

    private static String ucfc(String key) {
        return key.substring(0, 1).toUpperCase() + key.substring(1);
    }

    public Object[][] combinationsAsParameterArgs() {
        Set<Map<String, Object>> combinations = this.combinations();
        Object[][] rc = new Object[combinations.size()][];
        int i = 0;
        for (Map<String, Object> combination : combinations) {
            int j = 0;
            Object[] arg = new Object[combination.size()];
            for (Object object : combination.values()) {
                arg[j++] = object;
            }
            rc[i++] = arg;
        }
        return rc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CombinationAware {
        public void setCombination(Map<String, Object> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BeanFactory<T> {
        public T createBean() throws Exception;

        public Class<T> getBeanClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComboOption {
        final String attribute;
        final LinkedHashSet<Object> values = new LinkedHashSet();

        public ComboOption(String attribute, Collection<Object> options) {
            this.attribute = attribute;
            this.values.addAll(options);
        }
    }
}

