/* ڰ ̺귯 ϱ  ʿ header.
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef HRE_H
#define HRE_H

#define HDFA_RE(DFA)		((DFA)->re)
#define HDFA_TABLE(DFA)		((DFA)->table)
#define HDFA_TABLE_N(DFA, N)	((DFA)->table[(N)])
#define HDFA_INDEX(DFA)		((DFA)->tindex)
/* ڰ Է ѱ type   mask  ⿡ ϰ Ǵµ,
   ̰ ʿ  hre_search () Լ ؼ ˻ ϰ  ,  
   ѱ ڵ尪 ȣ (http://hre.kldp.net Ȩ .)   Ȯ 
   DFA ̺  ұϰ ߸ ڵ带 ã  ߰Ǿ.
   ڰ Է ԽĿ ϼ, ڵ,    ׿ 
   mask  . */
#define HDFA_HTMASK(DFA)	((DFA)->htmask)
#define HDFA_IS_SSAC(DFA)	((DFA)->is_ssac)
#define HDFA_RE_FAILED(DFA)	((DFA)->re_failed)
#define HDFA_ERRNO(DFA)		((DFA)->errno)

/*  v0.9  ϰ ִ  ǥ  , ϼ,
   ڵ带  ִ.  (ϼ   а   Ƿ
   Ȯ ϼ ڵ带 Ѵٴ  Ȯ ̴.)  */
#define HTMASK_JOHAB		0x1
#define HTMASK_EUC_KR		0x2
#define HTMASK_UTF_8		0x4

/* ü DFA ̺ ǥϴ ü.    ⿡ ؾ
   Ѵ.  */
struct hdfa
{
  int ** table;			/* ü DFA ̺  ּ */
  char *re;			/* ڰ Է  ǥ ڿ */
  int tindex;			/* ü DFA ̺ index ȣ */

  /* ڰ Է ѱ type   mask  ⿡ Ѵ.  */
  int htmask;
  int is_ssac;

  /* ڰ Է  ǥ hre_parser  ؼϴ 
      ߻ , ⿡ ǰ ȴ.  */
  int errno;

  /* ڰ Է  ǥ  ԽĿ  , 
     ã    ̰ 1  ȴ.  */
  int re_failed;
};

/*  ǥ mode  ؼ.  */
#define HRE_MODE_BRE		0x1
#define HRE_MODE_ERE		0x2

#define HRE_OPTIONS_MODE(OPT)	((OPT)->mode)

/* ڰ  ǥ  ,   ִ ɼ  
   ִ.  */
struct hre_options
{
  int mode;

  /* ǵ  . */
};

/*  ǥ type.
   ̰ ڰ Է  ǥ  ؼ   DFA
   ̺  ִ.  */
typedef struct hdfa * hre_t;
/*  ǥ ؼ 䱸    ִ ɼǵ.  */
typedef struct hre_options hre_option_t;

extern hre_t hre_compile (char *, struct hre_options *);
extern int hre_search (hre_t, const char *);
extern void hre_free (hre_t);

#endif
