/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.ClassicTransportCcEngine;
import org.jitsi.nlj.rtp.ClassicTransportCcEngine$tccReceived$;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.RtpSequenceIndexTracker;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.UnreceivedPacketReport;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.RangedStringKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0005;<=>?B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\"H\u0016J\u001a\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0016J\b\u00109\u001a\u00020$H\u0016J\b\u0010:\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine;", "Lorg/jitsi/nlj/rtp/TransportCcEngine;", "bandwidthEstimator", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "logger", "numPacketsReported", "Ljava/util/concurrent/atomic/LongAdder;", "getNumPacketsReported", "()Ljava/util/concurrent/atomic/LongAdder;", "numPacketsReportedLost", "getNumPacketsReportedLost", "numDuplicateReports", "getNumDuplicateReports", "numPacketsReportedAfterLost", "getNumPacketsReportedAfterLost", "numPacketsUnreported", "getNumPacketsUnreported", "numMissingPacketReports", "getNumMissingPacketReports", "remoteReferenceTime", "Ljava/time/Instant;", "localReferenceTime", "sentPacketDetails", "Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailTracker;", "missingPacketDetailSeqNums", "", "", "lastRtt", "Ljava/time/Duration;", "onRttUpdate", "", "rtt", "rtcpPacketReceived", "rtcpPacket", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "tccReceived", "tccPacket", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "mediaPacketTagged", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "tccSeqNum", "", "mediaPacketSent", "getStatistics", "Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$StatisticsSnapshot;", "addBandwidthListener", "listener", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "removeBandwidthListener", "start", "stop", "PacketDetailState", "PacketDetail", "StatisticsSnapshot", "PacketDetailTracker", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nClassicTransportCcEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicTransportCcEngine.kt\norg/jitsi/nlj/rtp/ClassicTransportCcEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,342:1\n1863#2,2:343\n1863#2,2:345\n477#3:347\n*S KotlinDebug\n*F\n+ 1 ClassicTransportCcEngine.kt\norg/jitsi/nlj/rtp/ClassicTransportCcEngine\n*L\n136#1:343,2\n168#1:345,2\n187#1:347\n*E\n"})
public final class ClassicTransportCcEngine
extends TransportCcEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BandwidthEstimator bandwidthEstimator;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LongAdder numPacketsReported;
    @NotNull
    private final LongAdder numPacketsReportedLost;
    @NotNull
    private final LongAdder numDuplicateReports;
    @NotNull
    private final LongAdder numPacketsReportedAfterLost;
    @NotNull
    private final LongAdder numPacketsUnreported;
    @NotNull
    private final LongAdder numMissingPacketReports;
    @NotNull
    private Instant remoteReferenceTime;
    @NotNull
    private Instant localReferenceTime;
    @NotNull
    private final PacketDetailTracker sentPacketDetails;
    @NotNull
    private final List<Integer> missingPacketDetailSeqNums;
    @Nullable
    private Duration lastRtt;
    private static final int MAX_OUTGOING_PACKETS_HISTORY = 1000;

    public ClassicTransportCcEngine(@NotNull BandwidthEstimator bandwidthEstimator, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(bandwidthEstimator, "bandwidthEstimator");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.bandwidthEstimator = bandwidthEstimator;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.numPacketsReported = new LongAdder();
        this.numPacketsReportedLost = new LongAdder();
        this.numDuplicateReports = new LongAdder();
        this.numPacketsReportedAfterLost = new LongAdder();
        this.numPacketsUnreported = new LongAdder();
        this.numMissingPacketReports = new LongAdder();
        this.remoteReferenceTime = InstantKt.NEVER;
        this.localReferenceTime = InstantKt.NEVER;
        this.sentPacketDetails = new PacketDetailTracker(this.clock);
        this.missingPacketDetailSeqNums = new ArrayList();
    }

    public /* synthetic */ ClassicTransportCcEngine(BandwidthEstimator bandwidthEstimator, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            clock = Clock.systemUTC();
        }
        this(bandwidthEstimator, logger, clock);
    }

    @NotNull
    public final LongAdder getNumPacketsReported() {
        return this.numPacketsReported;
    }

    @NotNull
    public final LongAdder getNumPacketsReportedLost() {
        return this.numPacketsReportedLost;
    }

    @NotNull
    public final LongAdder getNumDuplicateReports() {
        return this.numDuplicateReports;
    }

    @NotNull
    public final LongAdder getNumPacketsReportedAfterLost() {
        return this.numPacketsReportedAfterLost;
    }

    @NotNull
    public final LongAdder getNumPacketsUnreported() {
        return this.numPacketsUnreported;
    }

    @NotNull
    public final LongAdder getNumMissingPacketReports() {
        return this.numMissingPacketReports;
    }

    @Override
    public void onRttUpdate(@NotNull Duration rtt) {
        Intrinsics.checkNotNullParameter(rtt, "rtt");
        Instant now = this.clock.instant();
        Intrinsics.checkNotNull(now);
        this.bandwidthEstimator.onRttUpdate(now, rtt);
        this.lastRtt = rtt;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket rtcpPacket, @Nullable Instant receivedTime) {
        Intrinsics.checkNotNullParameter(rtcpPacket, "rtcpPacket");
        if (rtcpPacket instanceof RtcpFbTccPacket) {
            this.tccReceived((RtcpFbTccPacket)rtcpPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void tccReceived(RtcpFbTccPacket tccPacket) {
        block23: {
            Object object;
            Object object2;
            String string;
            String string2;
            Logger logger;
            block25: {
                Object object3;
                ClassicTransportCcEngine it;
                Logger logger2;
                String string3;
                String string4;
                Object object4;
                block24: {
                    void $this$filterIsInstance$iv;
                    Object packetDetail;
                    Instant now = this.clock.instant();
                    Instant currArrivalTimestamp = tccPacket.BaseTime();
                    if (Intrinsics.areEqual(this.remoteReferenceTime, InstantKt.NEVER)) {
                        this.remoteReferenceTime = currArrivalTimestamp;
                        this.localReferenceTime = now;
                    }
                    block10: for (PacketReport packetReport : tccPacket) {
                        int tccSeqNum = packetReport.getSeqNum();
                        packetDetail = this.sentPacketDetails.get(tccSeqNum);
                        if (packetDetail == null) {
                            if (!(packetReport instanceof ReceivedPacketReport)) continue;
                            currArrivalTimestamp = currArrivalTimestamp.plus(((ReceivedPacketReport)packetReport).getDeltaDuration());
                            this.missingPacketDetailSeqNums.add(tccSeqNum);
                            this.numMissingPacketReports.increment();
                            continue;
                        }
                        PacketReport packetReport2 = packetReport;
                        if (packetReport2 instanceof UnreceivedPacketReport) {
                            if (((PacketDetail)packetDetail).getState() != PacketDetailState.Unreported) continue;
                            Intrinsics.checkNotNull(now);
                            this.bandwidthEstimator.processPacketLoss(now, ((PacketDetail)packetDetail).getPacketSendTime(), tccSeqNum);
                            ((PacketDetail)packetDetail).setState(PacketDetailState.ReportedLost);
                            this.numPacketsReported.increment();
                            this.numPacketsReportedLost.increment();
                            ClassicTransportCcEngine classicTransportCcEngine = this;
                            synchronized (classicTransportCcEngine) {
                                boolean bl = false;
                                Iterable $this$forEach$iv = this.getLossListeners();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    LossListener it2 = (LossListener)element$iv;
                                    boolean bl2 = false;
                                    it2.packetLost(1);
                                }
                                Unit unit = Unit.INSTANCE;
                                continue;
                            }
                        }
                        if (packetReport2 instanceof ReceivedPacketReport) {
                            currArrivalTimestamp = currArrivalTimestamp.plus(((ReceivedPacketReport)packetReport).getDeltaDuration());
                            switch (WhenMappings.$EnumSwitchMapping$0[((PacketDetail)packetDetail).getState().ordinal()]) {
                                case 1: 
                                case 2: {
                                    boolean previouslyReportedLost;
                                    boolean bl = previouslyReportedLost = ((PacketDetail)packetDetail).getState() == PacketDetailState.ReportedLost;
                                    if (previouslyReportedLost) {
                                        this.numPacketsReportedAfterLost.increment();
                                        this.numPacketsReportedLost.decrement();
                                    } else {
                                        this.numPacketsReported.increment();
                                    }
                                    Instant arrivalTimeInLocalClock = currArrivalTimestamp.minus(Duration.between(this.localReferenceTime, this.remoteReferenceTime));
                                    Intrinsics.checkNotNull(now);
                                    BandwidthEstimator.processPacketArrival$default(this.bandwidthEstimator, now, ((PacketDetail)packetDetail).getPacketSendTime(), arrivalTimeInLocalClock, tccSeqNum, ((PacketDetail)packetDetail).getPacketLength(), (byte)0, previouslyReportedLost, 32, null);
                                    ClassicTransportCcEngine classicTransportCcEngine = this;
                                    synchronized (classicTransportCcEngine) {
                                        boolean bl3 = false;
                                        Iterable $this$forEach$iv = this.getLossListeners();
                                        boolean $i$f$forEach = false;
                                        for (Object element$iv : $this$forEach$iv) {
                                            LossListener it3 = (LossListener)element$iv;
                                            boolean bl4 = false;
                                            it3.packetReceived(previouslyReportedLost);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    ((PacketDetail)packetDetail).setState(PacketDetailState.ReportedReceived);
                                    continue block10;
                                }
                                case 3: {
                                    this.numDuplicateReports.increment();
                                    continue block10;
                                }
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    Intrinsics.checkNotNull(now);
                    this.bandwidthEstimator.feedbackComplete(now);
                    if (!(!((Collection)this.missingPacketDetailSeqNums).isEmpty())) break block23;
                    logger = this.logger;
                    Sequence<PacketReport> sequence = SequencesKt.asSequence(tccPacket.iterator());
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, tccReceived$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    string2 = RangedStringKt.joinToRangedString$default(SequencesKt.map(sequence2, tccReceived.3.INSTANCE), null, null, null, null, 0, null, 63, null);
                    string = RangedStringKt.joinToRangedString$default(this.missingPacketDetailSeqNums, null, null, null, null, 0, null, 63, null);
                    object2 = this.sentPacketDetails.getEmpty() ? "Sent packet details map was empty." : "Latest seqNum was " + this.sentPacketDetails.getLastSequence() + ", size is " + this.sentPacketDetails.getSize() + ".";
                    object = this.lastRtt;
                    if (object == null) break block24;
                    packetDetail = object;
                    object4 = object2;
                    string4 = string;
                    string3 = string2;
                    logger2 = logger;
                    boolean bl = false;
                    object3 = " Latest RTT is " + DurationKt.formatMilli((Duration)((Object)it)) + " ms.";
                    logger = logger2;
                    string2 = string3;
                    string = string4;
                    object2 = object4;
                    Object object5 = object3;
                    object = object5;
                    if (object5 != null) break block25;
                }
                it = this;
                object4 = object2;
                string4 = string;
                string3 = string2;
                logger2 = logger;
                boolean bl = false;
                object3 = "";
                logger = logger2;
                string2 = string3;
                string = string4;
                object2 = object4;
                object = object3;
            }
            logger.warn("TCC packet contained received sequence numbers: " + string2 + ". Couldn't find packet detail for the seq nums: " + string + ". " + (String)object2 + (String)object);
            this.missingPacketDetailSeqNums.clear();
        }
    }

    @Override
    public void mediaPacketTagged(@NotNull PacketInfo packetInfo, long tccSeqNum) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
    }

    @Override
    public void mediaPacketSent(@NotNull PacketInfo packetInfo, long tccSeqNum) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Instant now = this.clock.instant();
        int seq = (int)(tccSeqNum & 0xFFFFL);
        DataSize dataSize = DataSizeKt.getBytes(packetInfo.getPacket().length);
        Intrinsics.checkNotNull(now);
        if (!this.sentPacketDetails.insert(seq, new PacketDetail(dataSize, now))) {
            this.logger.warn("Not inserting very old TCC seq num " + seq + " (" + tccSeqNum + "), latest is " + this.sentPacketDetails.getLastSequence() + ", size is " + this.sentPacketDetails.getSize());
            return;
        }
    }

    @Override
    @NotNull
    public StatisticsSnapshot getStatistics() {
        return new StatisticsSnapshot(this.numPacketsReported.sum(), this.numPacketsReportedLost.sum(), this.numDuplicateReports.sum(), this.numPacketsReportedAfterLost.sum(), this.numPacketsUnreported.sum(), this.numMissingPacketReports.sum(), BandwidthEstimator.getStats$default(this.bandwidthEstimator, null, 1, null));
    }

    @Override
    public void addBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.bandwidthEstimator.addListener(listener);
    }

    @Override
    public void removeBandwidthListener(@NotNull TransportCcEngine.BandwidthListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.bandwidthEstimator.removeListener(listener);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$Companion;", "", "<init>", "()V", "MAX_OUTGOING_PACKETS_HISTORY", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetail;", "", "packetLength", "Lorg/jitsi/nlj/util/DataSize;", "packetSendTime", "Ljava/time/Instant;", "<init>", "(Lorg/jitsi/nlj/util/DataSize;Ljava/time/Instant;)V", "getPacketLength", "()Lorg/jitsi/nlj/util/DataSize;", "getPacketSendTime", "()Ljava/time/Instant;", "state", "Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailState;", "getState", "()Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailState;", "setState", "(Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailState;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    private static final class PacketDetail {
        @NotNull
        private final DataSize packetLength;
        @NotNull
        private final Instant packetSendTime;
        @NotNull
        private PacketDetailState state;

        public PacketDetail(@NotNull DataSize packetLength, @NotNull Instant packetSendTime) {
            Intrinsics.checkNotNullParameter(packetLength, "packetLength");
            Intrinsics.checkNotNullParameter(packetSendTime, "packetSendTime");
            this.packetLength = packetLength;
            this.packetSendTime = packetSendTime;
            this.state = PacketDetailState.Unreported;
        }

        @NotNull
        public final DataSize getPacketLength() {
            return this.packetLength;
        }

        @NotNull
        public final Instant getPacketSendTime() {
            return this.packetSendTime;
        }

        @NotNull
        public final PacketDetailState getState() {
            return this.state;
        }

        public final void setState(@NotNull PacketDetailState packetDetailState) {
            Intrinsics.checkNotNullParameter((Object)packetDetailState, "<set-?>");
            this.state = packetDetailState;
        }

        @NotNull
        public final DataSize component1() {
            return this.packetLength;
        }

        @NotNull
        public final Instant component2() {
            return this.packetSendTime;
        }

        @NotNull
        public final PacketDetail copy(@NotNull DataSize packetLength, @NotNull Instant packetSendTime) {
            Intrinsics.checkNotNullParameter(packetLength, "packetLength");
            Intrinsics.checkNotNullParameter(packetSendTime, "packetSendTime");
            return new PacketDetail(packetLength, packetSendTime);
        }

        public static /* synthetic */ PacketDetail copy$default(PacketDetail packetDetail, DataSize dataSize, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                dataSize = packetDetail.packetLength;
            }
            if ((n & 2) != 0) {
                instant = packetDetail.packetSendTime;
            }
            return packetDetail.copy(dataSize, instant);
        }

        @NotNull
        public String toString() {
            return "PacketDetail(packetLength=" + this.packetLength + ", packetSendTime=" + this.packetSendTime + ")";
        }

        public int hashCode() {
            int result = this.packetLength.hashCode();
            result = result * 31 + this.packetSendTime.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PacketDetail)) {
                return false;
            }
            PacketDetail packetDetail = (PacketDetail)other;
            if (!Intrinsics.areEqual(this.packetLength, packetDetail.packetLength)) {
                return false;
            }
            return Intrinsics.areEqual(this.packetSendTime, packetDetail.packetSendTime);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailState;", "", "<init>", "(Ljava/lang/String;I)V", "Unreported", "ReportedLost", "ReportedReceived", "jitsi-media-transform"})
    private static final class PacketDetailState
    extends Enum<PacketDetailState> {
        public static final /* enum */ PacketDetailState Unreported = new PacketDetailState();
        public static final /* enum */ PacketDetailState ReportedLost = new PacketDetailState();
        public static final /* enum */ PacketDetailState ReportedReceived = new PacketDetailState();
        private static final /* synthetic */ PacketDetailState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PacketDetailState[] values() {
            return (PacketDetailState[])$VALUES.clone();
        }

        public static PacketDetailState valueOf(String value2) {
            return Enum.valueOf(PacketDetailState.class, value2);
        }

        @NotNull
        public static EnumEntries<PacketDetailState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = packetDetailStateArray = new PacketDetailState[]{PacketDetailState.Unreported, PacketDetailState.ReportedLost, PacketDetailState.ReportedReceived};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetailTracker;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$PacketDetail;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine;Ljava/time/Clock;)V", "discardItem", "", "item", "rtpSequenceIndexTracker", "Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "get", "sequenceNumber", "", "insert", "", "seq", "packetDetail", "lastSequence", "getLastSequence", "()I", "jitsi-media-transform"})
    private final class PacketDetailTracker
    extends ArrayCache<PacketDetail> {
        @NotNull
        private final RtpSequenceIndexTracker rtpSequenceIndexTracker;

        public PacketDetailTracker(Clock clock) {
            Intrinsics.checkNotNullParameter(clock, "clock");
            super(1000, PacketDetailTracker::_init_$lambda$0, false, clock, 4, null);
            this.rtpSequenceIndexTracker = new RtpSequenceIndexTracker();
        }

        @Override
        protected void discardItem(@NotNull PacketDetail item) {
            Intrinsics.checkNotNullParameter(item, "item");
            if (item.getState() == PacketDetailState.Unreported) {
                ClassicTransportCcEngine.this.getNumPacketsUnreported().increment();
            }
        }

        @Nullable
        public final PacketDetail get(int sequenceNumber) {
            long index = this.rtpSequenceIndexTracker.interpret(sequenceNumber);
            ArrayCache.Container container = super.getContainer(index, true);
            return container != null ? (PacketDetail)container.getItem() : null;
        }

        public final boolean insert(int seq, @NotNull PacketDetail packetDetail) {
            Intrinsics.checkNotNullParameter(packetDetail, "packetDetail");
            long index = this.rtpSequenceIndexTracker.update(seq);
            return super.insertItem(packetDetail, index, packetDetail.getPacketSendTime().toEpochMilli());
        }

        public final int getLastSequence() {
            return this.getLastIndex() == -1L ? -1 : (int)(this.getLastIndex() & 0xFFFFL);
        }

        private static final PacketDetail _init_$lambda$0(PacketDetail it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/rtp/ClassicTransportCcEngine$StatisticsSnapshot;", "Lorg/jitsi/nlj/rtp/TransportCcEngine$StatisticsSnapshot;", "numPacketsReported", "", "numPacketsReportedLost", "numDuplicateReports", "numPacketsReportedAfterLost", "numPacketsUnreported", "numMissingPacketReports", "bandwidthEstimatorStats", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "<init>", "(JJJJJJLorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;)V", "getNumPacketsReported", "()J", "getNumPacketsReportedLost", "getNumDuplicateReports", "getNumPacketsReportedAfterLost", "getNumPacketsUnreported", "getNumMissingPacketReports", "getBandwidthEstimatorStats", "()Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$StatisticsSnapshot;", "toJson", "", "jitsi-media-transform"})
    public static final class StatisticsSnapshot
    extends TransportCcEngine.StatisticsSnapshot {
        private final long numPacketsReported;
        private final long numPacketsReportedLost;
        private final long numDuplicateReports;
        private final long numPacketsReportedAfterLost;
        private final long numPacketsUnreported;
        private final long numMissingPacketReports;
        @NotNull
        private final BandwidthEstimator.StatisticsSnapshot bandwidthEstimatorStats;

        public StatisticsSnapshot(long numPacketsReported, long numPacketsReportedLost, long numDuplicateReports, long numPacketsReportedAfterLost, long numPacketsUnreported, long numMissingPacketReports, @NotNull BandwidthEstimator.StatisticsSnapshot bandwidthEstimatorStats) {
            Intrinsics.checkNotNullParameter(bandwidthEstimatorStats, "bandwidthEstimatorStats");
            this.numPacketsReported = numPacketsReported;
            this.numPacketsReportedLost = numPacketsReportedLost;
            this.numDuplicateReports = numDuplicateReports;
            this.numPacketsReportedAfterLost = numPacketsReportedAfterLost;
            this.numPacketsUnreported = numPacketsUnreported;
            this.numMissingPacketReports = numMissingPacketReports;
            this.bandwidthEstimatorStats = bandwidthEstimatorStats;
        }

        public final long getNumPacketsReported() {
            return this.numPacketsReported;
        }

        public final long getNumPacketsReportedLost() {
            return this.numPacketsReportedLost;
        }

        public final long getNumDuplicateReports() {
            return this.numDuplicateReports;
        }

        public final long getNumPacketsReportedAfterLost() {
            return this.numPacketsReportedAfterLost;
        }

        public final long getNumPacketsUnreported() {
            return this.numPacketsUnreported;
        }

        public final long getNumMissingPacketReports() {
            return this.numMissingPacketReports;
        }

        @NotNull
        public final BandwidthEstimator.StatisticsSnapshot getBandwidthEstimatorStats() {
            return this.bandwidthEstimatorStats;
        }

        @Override
        @NotNull
        public Map<?, ?> toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject it = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            String string = ClassicTransportCcEngine.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "getSimpleName(...)");
            it.put("name", string);
            it.put("numPacketsReported", (Object)this.numPacketsReported);
            it.put("numPacketsReportedLost", (Object)this.numPacketsReportedLost);
            it.put("numDuplicateReports", (Object)this.numDuplicateReports);
            it.put("numPacketsReportedAfterLost", (Object)this.numPacketsReportedAfterLost);
            it.put("numPacketsUnreported", (Object)this.numPacketsUnreported);
            it.put("numMissingPacketReports", (Object)this.numMissingPacketReports);
            it.put("bandwidth_estimator_stats", this.bandwidthEstimatorStats.toJson());
            return orderedJsonObject;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketDetailState.values().length];
            try {
                nArray[PacketDetailState.Unreported.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PacketDetailState.ReportedLost.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PacketDetailState.ReportedReceived.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

