/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.AlrDetectorConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.IntervalBudget;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetector;", "", "<init>", "()V", "onBytesSent", "", "bytesSent", "", "sendTimeMs", "setEstimatedBitrate", "bitrateBps", "", "getApplicationLimitedRegionStartTime", "()Ljava/lang/Long;", "conf", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetectorConfig;", "lastSendTimeMs", "Ljava/lang/Long;", "alrBudget", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/IntervalBudget;", "alrStartedTimeMs", "Companion", "jitsi-media-transform"})
public final class AlrDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlrDetectorConfig conf = kDefaultProbingScreenshareBweSettings;
    @Nullable
    private Long lastSendTimeMs;
    @NotNull
    private final IntervalBudget alrBudget = new IntervalBudget(0, true);
    @Nullable
    private Long alrStartedTimeMs;
    @NotNull
    private static final AlrDetectorConfig kDefaultProbingScreenshareBweSettings = new AlrDetectorConfig(0.8, 0.4, -0.6);

    public final void onBytesSent(long bytesSent, long sendTimeMs) {
        if (this.lastSendTimeMs == null) {
            this.lastSendTimeMs = sendTimeMs;
            return;
        }
        Long l = this.lastSendTimeMs;
        Intrinsics.checkNotNull(l);
        long deltaTimeMs = sendTimeMs - l;
        this.lastSendTimeMs = sendTimeMs;
        this.alrBudget.useBudget(bytesSent);
        this.alrBudget.increaseBudget(deltaTimeMs);
        boolean stateChanged = false;
        if (this.alrBudget.budgetRatio() > this.conf.getStartBudgetLevelRatio() && this.alrStartedTimeMs == null) {
            this.alrStartedTimeMs = System.currentTimeMillis();
            stateChanged = true;
        } else if (this.alrBudget.budgetRatio() < this.conf.getStartBudgetLevelRatio() && this.alrStartedTimeMs != null) {
            stateChanged = true;
            this.alrStartedTimeMs = null;
        }
        if (stateChanged) {
            // empty if block
        }
    }

    public final void setEstimatedBitrate(int bitrateBps) {
        double targetRateKbps = (double)bitrateBps * this.conf.getBandwidthUsageRatio() / (double)1000;
        this.alrBudget.setTargetRateKbps((int)targetRateKbps);
    }

    @Nullable
    public final Long getApplicationLimitedRegionStartTime() {
        return this.alrStartedTimeMs;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetector$Companion;", "", "<init>", "()V", "kDefaultProbingScreenshareBweSettings", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetectorConfig;", "getKDefaultProbingScreenshareBweSettings", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/AlrDetectorConfig;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AlrDetectorConfig getKDefaultProbingScreenshareBweSettings() {
            return kDefaultProbingScreenshareBweSettings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

