/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u000b\u00a2\u0006\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006#"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/LinkCapacityTracker;", "", "<init>", "()V", "capacityEstimateBps", "", "lastLinkCapcityUpdate", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "lastDelayBasedEstimate", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "updateDelayBasedEstimate", "", "atTime", "delayBasedEstimate", "updateDelayBasedEstimate-ERFH51c", "(Ljava/time/Instant;J)V", "onStartingRate", "startRate", "onStartingRate-_2icLw0", "(J)V", "onRateUpdate", "acknowledged", "target", "onRateUpdate-IYc3OHo", "(Lorg/jitsi/nlj/util/Bandwidth;JLjava/time/Instant;)V", "onRttBackoff", "backoffRate", "onRttBackoff-SimD6oM", "(JLjava/time/Instant;)V", "estimate", "estimate-rlWvAKk", "()J", "jitsi-media-transform"})
public final class LinkCapacityTracker {
    private double capacityEstimateBps;
    private Instant lastLinkCapcityUpdate = Instant.MIN;
    private long lastDelayBasedEstimate = Bandwidth.Companion.getINFINITY-rlWvAKk();

    public final void updateDelayBasedEstimate-ERFH51c(@NotNull Instant atTime, long delayBasedEstimate) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        if (Bandwidth.compareTo-_2icLw0(delayBasedEstimate, this.lastDelayBasedEstimate) < 0) {
            this.capacityEstimateBps = Math.min(this.capacityEstimateBps, (double)delayBasedEstimate);
            this.lastLinkCapcityUpdate = atTime;
        }
        this.lastDelayBasedEstimate = delayBasedEstimate;
    }

    public final void onStartingRate-_2icLw0(long startRate) {
        Instant instant = this.lastLinkCapcityUpdate;
        Intrinsics.checkNotNullExpressionValue(instant, "lastLinkCapcityUpdate");
        if (InstantKt.isInfinite(instant)) {
            this.capacityEstimateBps = startRate;
        }
    }

    public final void onRateUpdate-IYc3OHo(@Nullable Bandwidth acknowledged, long target, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        if (acknowledged == null) {
            return;
        }
        long acknowledgedTarget = BandwidthKt.min-YUm52VA(acknowledged.unbox-impl(), target);
        if ((double)acknowledgedTarget > this.capacityEstimateBps) {
            double d;
            Instant instant = this.lastLinkCapcityUpdate;
            Intrinsics.checkNotNullExpressionValue(instant, "lastLinkCapcityUpdate");
            if (InstantKt.isFinite(instant) && InstantKt.isFinite(atTime)) {
                Duration delta = Duration.between(this.lastLinkCapcityUpdate, atTime);
                Intrinsics.checkNotNull(delta);
                d = Math.exp(-DurationKt.div(delta, DurationKt.getSecs(10)));
            } else {
                d = 0.0;
            }
            double alpha = d;
            this.capacityEstimateBps = alpha * this.capacityEstimateBps * alpha + (1.0 - alpha) * (double)acknowledgedTarget;
        }
        this.lastLinkCapcityUpdate = atTime;
    }

    public final void onRttBackoff-SimD6oM(long backoffRate, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        this.capacityEstimateBps = Math.min(this.capacityEstimateBps, (double)backoffRate);
        this.lastLinkCapcityUpdate = atTime;
    }

    public final long estimate-rlWvAKk() {
        return BandwidthKt.getBps(this.capacityEstimateBps);
    }
}

