/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import kafka.log.SkimpyOffsetMap$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011Qb\u00144gg\u0016$X*\u00199UKN$(BA\u0002\u0005\u0003\rawn\u001a\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!\t!G\u0001\u0014i\u0016\u001cHOQ1tS\u000e4\u0016\r\\5eCRLwN\u001c\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t!QK\\5uQ\t9\u0012\u0005\u0005\u0002#I5\t1E\u0003\u0002\f\u001d%\u0011Qe\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011\u0005\u0011$A\u0005uKN$8\t\\3be\"\u0012a%\t\u0005\u0006U\u0001!\t!G\u0001\u0010i\u0016\u001cHoR3u/\",gNR;mY\"\u0012\u0011&\t\u0005\u0006[\u0001!\tAL\u0001\u0004W\u0016LHCA\u00188!\t\u0001T'D\u00012\u0015\t\u00114'A\u0002oS>T\u0011\u0001N\u0001\u0005U\u00064\u0018-\u0003\u00027c\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000b5b\u0003\u0019\u0001\u001d\u0011\u0005mI\u0014B\u0001\u001e\u001d\u0005\u0011auN\\4\t\u000bq\u0002A\u0011A\u001f\u0002\u0017Y\fG.\u001b3bi\u0016l\u0015\r\u001d\u000b\u0004}\u00053\u0005C\u0001\f@\u0013\t\u0001%AA\bTW&l\u0007/_(gMN,G/T1q\u0011\u0015\u00115\b1\u0001D\u0003\u0015IG/Z7t!\tYB)\u0003\u0002F9\t\u0019\u0011J\u001c;\t\u000f\u001d[\u0004\u0013!a\u0001\u0011\u0006QAn\\1e\r\u0006\u001cGo\u001c:\u0011\u0005mI\u0015B\u0001&\u001d\u0005\u0019!u.\u001e2mK\"9A\nAI\u0001\n\u0003i\u0015!\u0006<bY&$\u0017\r^3NCB$C-\u001a4bk2$HEM\u000b\u0002\u001d*\u0012\u0001jT\u0016\u0002!B\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0016\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002X%\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000be\u0013\u0001\u0012\u0001.\u0002\u001b=3gm]3u\u001b\u0006\u0004H+Z:u!\t12LB\u0003\u0002\u0005!\u0005AlE\u0002\\;\u0002\u0004\"a\u00070\n\u0005}c\"AB!osJ+g\r\u0005\u0002\u001cC&\u0011!\r\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006'm#\t\u0001\u001a\u000b\u00025\")am\u0017C\u0001O\u0006!Q.Y5o)\tQ\u0002\u000eC\u0003jK\u0002\u0007!.\u0001\u0003be\u001e\u001c\bcA\u000el[&\u0011A\u000e\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003]Vt!a\\:\u0011\u0005AdR\"A9\u000b\u0005I4\u0011A\u0002\u001fs_>$h(\u0003\u0002u9\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!H\u0004C\u0004z7\u0006\u0005I\u0011\u0002>\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011apM\u0001\u0005Y\u0006tw-C\u0002\u0002\u0002u\u0014aa\u00142kK\u000e$\b")
public class OffsetMapTest
extends JUnitSuite {
    public static void main(String[] stringArray) {
        OffsetMapTest$.MODULE$.main(stringArray);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assert.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assert.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)key)).toString().getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

