/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

class KTableFilter<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final KTableImpl<K, ?, V> parent;
    private final Predicate<? super K, ? super V> predicate;
    private final boolean filterNot;
    private final String queryableName;
    private boolean sendOldValues = false;

    KTableFilter(KTableImpl<K, ?, V> parent, Predicate<? super K, ? super V> predicate, boolean filterNot, String queryableName) {
        this.parent = parent;
        this.predicate = predicate;
        this.filterNot = filterNot;
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableFilterProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.parent.enableSendingOldValues();
        this.sendOldValues = true;
    }

    private V computeValue(K key, V value) {
        V newValue = null;
        if (value != null && this.filterNot ^ this.predicate.test(key, value)) {
            newValue = value;
        }
        return newValue;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        if (this.queryableName != null) {
            return new KTableMaterializedValueGetterSupplier(this.queryableName);
        }
        return new KTableValueGetterSupplier<K, V>(){
            final KTableValueGetterSupplier<K, V> parentValueGetterSupplier;
            {
                this.parentValueGetterSupplier = KTableFilter.this.parent.valueGetterSupplier();
            }

            @Override
            public KTableValueGetter<K, V> get() {
                return new KTableFilterValueGetter(this.parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return this.parentValueGetterSupplier.storeNames();
            }
        };
    }

    private class KTableFilterValueGetter
    implements KTableValueGetter<K, V> {
        private final KTableValueGetter<K, V> parentGetter;

        KTableFilterValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public V get(K key) {
            return KTableFilter.this.computeValue(key, this.parentGetter.get(key));
        }
    }

    private class KTableFilterProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;

        private KTableFilterProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableFilter.this.queryableName != null) {
                this.store = (KeyValueStore)context.getStateStore(KTableFilter.this.queryableName);
                this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KTableFilter.this.sendOldValues), KTableFilter.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> change) {
            Object oldValue;
            Object newValue = KTableFilter.this.computeValue(key, change.newValue);
            Object object = oldValue = KTableFilter.this.sendOldValues ? KTableFilter.this.computeValue(key, change.oldValue) : null;
            if (KTableFilter.this.sendOldValues && oldValue == null && newValue == null) {
                return;
            }
            if (KTableFilter.this.queryableName != null) {
                this.store.put(key, newValue);
                this.tupleForwarder.maybeForward(key, newValue, oldValue);
            } else {
                this.context().forward(key, new Change<Object>(newValue, oldValue));
            }
        }
    }
}

