/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.CompositeRestoreListener;

public class StateRestorer {
    static final int NO_CHECKPOINT = -1;
    private final Long checkpoint;
    private final long offsetLimit;
    private final boolean persistent;
    private final String storeName;
    private final TopicPartition partition;
    private final CompositeRestoreListener compositeRestoreListener;
    private long restoredOffset;
    private long startingOffset;
    private long endingOffset;

    StateRestorer(TopicPartition partition, CompositeRestoreListener compositeRestoreListener, Long checkpoint, long offsetLimit, boolean persistent, String storeName) {
        this.partition = partition;
        this.compositeRestoreListener = compositeRestoreListener;
        this.checkpoint = checkpoint;
        this.offsetLimit = offsetLimit;
        this.persistent = persistent;
        this.storeName = storeName;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    long checkpoint() {
        return this.checkpoint == null ? -1L : this.checkpoint;
    }

    void restoreStarted() {
        this.compositeRestoreListener.onRestoreStart(this.partition, this.storeName, this.startingOffset, this.endingOffset);
    }

    void restoreDone() {
        this.compositeRestoreListener.onRestoreEnd(this.partition, this.storeName, this.restoredNumRecords());
    }

    void restoreBatchCompleted(long currentRestoredOffset, int numRestored) {
        this.compositeRestoreListener.onBatchRestored(this.partition, this.storeName, currentRestoredOffset, numRestored);
    }

    void restore(Collection<KeyValue<byte[], byte[]>> records) {
        this.compositeRestoreListener.restoreAll(records);
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setUserRestoreListener(StateRestoreListener userRestoreListener) {
        this.compositeRestoreListener.setUserRestoreListener(userRestoreListener);
    }

    void setRestoredOffset(long restoredOffset) {
        this.restoredOffset = Math.min(this.offsetLimit, restoredOffset);
    }

    void setStartingOffset(long startingOffset) {
        this.startingOffset = Math.min(this.offsetLimit, startingOffset);
    }

    void setEndingOffset(long endingOffset) {
        this.endingOffset = Math.min(this.offsetLimit, endingOffset);
    }

    long startingOffset() {
        return this.startingOffset;
    }

    boolean hasCompleted(long recordOffset, long endOffset) {
        return endOffset == 0L || recordOffset >= this.readTo(endOffset);
    }

    Long restoredOffset() {
        return this.restoredOffset;
    }

    long restoredNumRecords() {
        return this.restoredOffset - this.startingOffset;
    }

    long offsetLimit() {
        return this.offsetLimit;
    }

    private Long readTo(long endOffset) {
        return endOffset < this.offsetLimit ? endOffset : this.offsetLimit;
    }
}

