/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpException;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;

public class TestInjectionSQLFingerprint
extends AbstractAppParamPlugin {
    private static final int TIME_SPREAD = 15000;
    private static final String MSSQL_DELAY_1 = "';waitfor delay '0:0:15';--";
    private static final String MSSQL_DELAY_2 = ";waitfor delay '0:0:15';--";
    private static final String SQL_BLIND_MS_INSERT = ");waitfor delay '0:0:15';--";
    private static final String SQL_BLIND_INSERT = ");--";
    private static final String SQL_CHECK_ERR = "'INJECTED_PARAM";
    private static final Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 10);
    private static final Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 10);
    private static final Pattern patternErrorGeneric = Pattern.compile("JDBC|ODBC|not a valid MySQL|SQL", 10);
    private static final Pattern patternErrorODBCMSSQL = Pattern.compile("ODBC SQL Server Driver", 10);
    private String mResBodyError = "";

    public int getId() {
        return 40000;
    }

    public String getName() {
        return "SQL Injection Fingerprinting";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "SQL injection may be possible.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Do not trust client side input even if there is client side validation.  In general, <ul><li>If the input string is numeric, type check it.</li><li>If the application used JDBC, use PreparedStatement or CallableStatement with parameters passed by '?'</li><li>If the application used ASP, use ADO Command Objects with strong type checking and parameterized query.</li><li>If stored procedure or bind variables can be used, use it for parameter passing into query.  Do not just concatenate string into query in the stored procedure!</li><li>Do not create dynamic SQL query by simple string concatentation.</li><li>Use minimum database user privilege for the application.  This does not eliminate SQL injection but minimize its damage.  Eg if the application require reading one table only, grant such access to the application.  Avoid using 'sa' or 'db-owner'.</li></ul>";
        return string;
    }

    public String getReference() {
        String string = "<ul><li>The OWASP guide at http://www.owasp.org/documentation/guide</li><li>http://www.sqlsecurity.com/DesktopDefault.aspx?tabid=23</li><li>http://www.spidynamics.com/whitepapers/WhitepaperSQLInjection.pdf</li><li>For Oracle database, refer to http://www.integrigy.com/info/IntegrigyIntrotoSQLInjectionAttacks.pdf</li></ul>";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        try {
            this.scanMSSQL(httpMessage, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void scanMSSQL(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        Object var4_4 = null;
        Object var5_5 = null;
        String string3 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        HttpMessage httpMessage2 = this.getNewMsg();
        string3 = this.setParameter(httpMessage2, string, string2 + SQL_CHECK_ERR);
        l3 = System.currentTimeMillis();
        this.sendAndReceive(httpMessage2);
        l = System.currentTimeMillis() - l3;
        this.mResBodyError = httpMessage2.getResponseBody().toString();
        if (this.checkResult(httpMessage2, string3)) {
            return;
        }
        string3 = this.setParameter(httpMessage2, string, string2 + MSSQL_DELAY_1);
        l3 = System.currentTimeMillis();
        this.sendAndReceive(httpMessage2);
        l2 = System.currentTimeMillis() - l3;
        if (this.checkMSTimeResult(httpMessage2, string3, l, l2)) {
            return;
        }
        string3 = this.setParameter(httpMessage2, string, string2 + MSSQL_DELAY_2);
        l3 = System.currentTimeMillis();
        this.sendAndReceive(httpMessage2);
        l2 = System.currentTimeMillis() - l3;
        if (this.checkMSTimeResult(httpMessage2, string3, l, l2)) {
            return;
        }
        this.testMSBlindINSERT(httpMessage2, string, string2);
    }

    private void testMSBlindINSERT(HttpMessage httpMessage, String string, String string2) throws HttpException, IOException {
        Object var4_4 = null;
        Object var5_5 = null;
        String string3 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        boolean bl = false;
        long l = 0L;
        int n = 5;
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",'0'");
            }
            string3 = this.setParameter(httpMessage, string, string2 + "'" + stringBuffer.toString() + SQL_BLIND_MS_INSERT);
            this.sendAndReceive(httpMessage);
            if (this.checkMSTimeResult(httpMessage, string3, l, httpMessage.getTimeElapsedMillis())) {
                return;
            }
            try {
                long l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            string3 = this.setParameter(httpMessage, string, string2 + stringBuffer.toString() + SQL_BLIND_MS_INSERT);
            this.sendAndReceive(httpMessage);
            if (!this.checkMSTimeResult(httpMessage, string3, l, httpMessage.getTimeElapsedMillis())) continue;
            return;
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (httpMessage.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBC1, stringBuffer) || this.matchBodyPattern(httpMessage, patternErrorODBC2, stringBuffer)) {
            bl = true;
        } else if (this.matchBodyPattern(httpMessage, patternErrorGeneric, stringBuffer)) {
            this.bingo(3, 0, null, string, stringBuffer.toString(), httpMessage);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (this.matchBodyPattern(httpMessage, patternErrorODBCMSSQL, stringBuffer)) {
            this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
            return true;
        }
        return true;
    }

    private boolean checkMSTimeResult(HttpMessage httpMessage, String string, long l, long l2) {
        if (l2 > l + 15000L - 500L) {
            this.getKb().add(httpMessage.getRequestHeader().getURI(), "sql/mssql", (Object)new Boolean(true));
            return true;
        }
        return false;
    }
}

