/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as v,html as c,nothing as h}from"lit";import{repeat as f}from"lit/directives/repeat.js";import{classMap as m}from"lit/directives/class-map.js";import{live as u}from"lit/directives/live.js";import{property as r,state as g,customElement as y}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";var s=function(p,e,t,i){var a=arguments.length,l=a<3?e:i===null?i=Object.getOwnPropertyDescriptor(e,t):i,n;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")l=Reflect.decorate(p,e,t,i);else for(var d=p.length-1;d>=0;d--)(n=p[d])&&(l=(a<3?n(l):a>3?n(e,t,l):n(e,t))||l);return a>3&&l&&Object.defineProperty(e,t,l),l};class b extends Event{static{this.eventName="typo3:backend:form-editor:component:property-grid-editor:update"}constructor(e){super(b.eventName),this.data=e}}let o=class extends v{constructor(){super(...arguments),this.entries=[],this.labelLabel="Label",this.labelValue="Value",this.labelSelected="Selected",this.labelAdd="Add",this.labelRemove="Remove",this.labelMove="Move",this.enableAddRow=!1,this.enableDeleteRow=!1,this.enableSelection=!0,this.enableMultiSelection=!1,this.enableSorting=!1,this.enableLabelAsFallbackValue=!1,this.draggedEntry=null,this.movedEntry=null,this.activeElementRef=null}createRenderRoot(){return this}updated(e){if(this.activeElementRef&&(this.activeElementRef.focus(),this.activeElementRef=null),e.has("entries")){const t=e.get("entries");t!==void 0&&JSON.stringify(t)!==JSON.stringify(this.entries)&&this.dispatchEvent(new b(this.entries))}}render(){return c`<div class=property-grid-editor>${this.entries?.length?c`<div class=property-grid-editor__entries>${f(this.entries,e=>e.id,e=>this.renderEntry(e))}</div>`:h} ${this.enableAddRow?c`<div class=property-grid-editor__actions><button class="btn btn-sm btn-default" title=${this.labelAdd} @click=${this.handleCreate}><typo3-backend-icon identifier=actions-plus size=small></typo3-backend-icon><span class=btn-label>${this.labelAdd}</span></button></div>`:h}</div>`}renderEntry(e){return c`<div class=${m({"property-grid-editor__entry":!0,moving:this.movedEntry===e,dragging:this.draggedEntry===e})} @dragover=${t=>this.handleDragOver(t)} @dragenter=${t=>this.handleDragEnter(t,e)} @drop=${t=>this.handleDrop(t)} @dragend=${t=>this.handleDragEnd(t)}><div class=property-grid-editor__entry-inputs><div class=form-group><label for=${e.id}-label class=form-label>${this.labelLabel}</label> <input id=${e.id}-label class="form-control form-control-sm" type=text @change=${t=>this.handleChange(t,"label",e)} @keyup=${t=>this.handleChange(t,"label",e)} @paste=${t=>this.handleChange(t,"label",e)} @focusout=${t=>this.handleFocusOut(t,"label",e)} .value=${u(e.label)}></div><div class=form-group><label for=${e.id}-value class=form-label>${this.labelValue}</label> <input id=${e.id}-value class="form-control form-control-sm" type=text @change=${t=>this.handleChange(t,"value",e)} @keyup=${t=>this.handleChange(t,"value",e)} @paste=${t=>this.handleChange(t,"value",e)} @focusout=${t=>this.handleFocusOut(t,"value",e)} .value=${u(e.value)}></div>${this.enableSelection||this.enableMultiSelection?c`<div class=form-check><input id=${e.id}-selected class=form-check-input type=checkbox @change=${t=>this.handleChange(t,"selected",e)} @focusout=${t=>this.handleFocusOut(t,"selected",e)} .checked=${u(e.selected)}> <label for=${e.id}-selected class=form-check-label>${this.labelSelected}</label></div>`:h}</div>${this.enableSorting||this.enableDeleteRow?c`<div class=property-grid-editor__entry-buttons>${this.enableSorting?c`<button class="btn btn-sm btn-default" title=${this.labelMove} draggable=true @click=${t=>this.handleMoveClick(t,e)} @keydown=${this.handleMoveKeyDown} @dragstart=${t=>this.handleDragStart(t,e)}><typo3-backend-icon identifier=${this.movedEntry===e?"actions-thumbtack":"actions-move-move"} size=small></typo3-backend-icon></button>`:h} ${this.enableDeleteRow?c`<button class="btn btn-sm btn-default" title=${this.labelRemove} @click=${()=>this.handleRemove(e)}><typo3-backend-icon identifier=actions-delete size=small></typo3-backend-icon></button>`:h}</div>`:h}</div>`}handleFocusOut(e,t,i){this.enableLabelAsFallbackValue&&t==="label"&&i.value===""&&this.setEntryProperty(i,"value",i.label)}handleChange(e,t,i){const a=e.target,l=a.type==="checkbox"?a.checked:a.value;this.setEntryProperty(i,t,l)}handleRemove(e){this.entries=this.entries.filter(t=>t!==e)}handleCreate(){const e={id:"fe"+Math.floor(Math.random()*42)+Date.now(),label:"",value:"",selected:!1};this.entries=[...this.entries,e]}handleDragStart(e,t){e.stopImmediatePropagation(),this.draggedEntry=t,e.dataTransfer?.setData("text/plain","dragging"),e.dataTransfer?.setDragImage(new Image,0,0)}handleDragOver(e){e.preventDefault(),e.stopImmediatePropagation()}handleDragEnter(e,t){if(e.preventDefault(),e.stopImmediatePropagation(),!this.draggedEntry||this.draggedEntry===t)return;const i=[...this.entries],a=i.indexOf(this.draggedEntry),l=i.indexOf(t);i.splice(a,1);const n=(a<l,l);i.splice(n,0,this.draggedEntry),this.entries=i}handleDrop(e){e.preventDefault(),e.stopImmediatePropagation(),this.draggedEntry=null}handleDragEnd(e){e.stopImmediatePropagation(),this.draggedEntry=null}handleMoveClick(e,t){this.movedEntry===t?this.movedEntry=null:this.movedEntry=t}handleMoveKeyDown(e){if(this.movedEntry===null||!["ArrowDown","ArrowUp","Home","End","Enter","Space","Escape","Tab"].includes(e.code)||e.altKey||e.ctrlKey)return;e.preventDefault();let i;switch(e.code){case"Escape":case"Enter":case"Space":this.movedEntry=null;return;case"ArrowUp":i=-1;break;case"ArrowDown":i=1;break;default:return}const a=[...this.entries],l=a.indexOf(this.movedEntry),n=l+i;if(console.log(l,n),n<0||n>=a.length)return;a.splice(l,1);const d=(l<n,n);a.splice(d,0,this.movedEntry),this.entries=a,this.activeElementRef=e.target.closest("button")}setEntryProperty(e,t,i){const a=this.entries.indexOf(e);if(a===-1)return;const l={...e};if(t==="label"&&(l.label=String(i)),t==="value"&&(l.value=String(i)),t==="selected"&&(l.selected=!!i,l.selected===!0&&!this.enableMultiSelection)){this.entries=this.entries.map((n,d)=>d===a?l:{...n,selected:!1});return}this.entries=this.entries.map((n,d)=>d===a?l:n)}};s([r({type:Array,attribute:"entries"})],o.prototype,"entries",void 0),s([r({type:String,attribute:"label-label"})],o.prototype,"labelLabel",void 0),s([r({type:String,attribute:"label-value"})],o.prototype,"labelValue",void 0),s([r({type:String,attribute:"label-selected"})],o.prototype,"labelSelected",void 0),s([r({type:String,attribute:"label-add"})],o.prototype,"labelAdd",void 0),s([r({type:String,attribute:"label-remove"})],o.prototype,"labelRemove",void 0),s([r({type:String,attribute:"label-move"})],o.prototype,"labelMove",void 0),s([r({type:Boolean})],o.prototype,"enableAddRow",void 0),s([r({type:Boolean})],o.prototype,"enableDeleteRow",void 0),s([r({type:Boolean})],o.prototype,"enableSelection",void 0),s([r({type:Boolean})],o.prototype,"enableMultiSelection",void 0),s([r({type:Boolean})],o.prototype,"enableSorting",void 0),s([r({type:Boolean})],o.prototype,"enableLabelAsFallbackValue",void 0),s([g()],o.prototype,"draggedEntry",void 0),s([g()],o.prototype,"movedEntry",void 0),o=s([y("typo3-form-property-grid-editor")],o);export{o as PropertyGridEditor,b as PropertyGridEditorUpdateEvent};
