/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.net.IncomingStreamingConnection;
import org.apache.cassandra.streaming.DefaultConnectionFactory;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamCoordinator;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamException;
import org.apache.cassandra.streaming.StreamManager;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamResultFuture
extends AbstractFuture<StreamState> {
    private static final Logger logger = LoggerFactory.getLogger(StreamResultFuture.class);
    public final UUID planId;
    public final String description;
    private final StreamCoordinator coordinator;
    private final Collection<StreamEventHandler> eventListeners = new ConcurrentLinkedQueue<StreamEventHandler>();

    private StreamResultFuture(UUID planId, String description, StreamCoordinator coordinator) {
        this.planId = planId;
        this.description = description;
        this.coordinator = coordinator;
        if (!coordinator.isReceiving() && !coordinator.hasActiveSessions()) {
            this.set(this.getCurrentState());
        }
    }

    private StreamResultFuture(UUID planId, String description, boolean keepSSTableLevels, boolean isIncremental) {
        this(planId, description, new StreamCoordinator(0, keepSSTableLevels, isIncremental, new DefaultConnectionFactory()));
    }

    static StreamResultFuture init(UUID planId, String description, Collection<StreamEventHandler> listeners, StreamCoordinator coordinator) {
        StreamResultFuture future = StreamResultFuture.createAndRegister(planId, description, coordinator);
        if (listeners != null) {
            for (StreamEventHandler listener : listeners) {
                future.addEventListener(listener);
            }
        }
        logger.info("[Stream #{}] Executing streaming plan for {}", (Object)planId, (Object)description);
        for (StreamSession session : coordinator.getAllStreamSessions()) {
            session.init(future);
        }
        coordinator.connectAllStreamSessions();
        return future;
    }

    public static synchronized StreamResultFuture initReceivingSide(int sessionIndex, UUID planId, String description, InetAddress from, IncomingStreamingConnection connection, boolean isForOutgoing, int version, boolean keepSSTableLevel, boolean isIncremental) throws IOException {
        StreamResultFuture future = StreamManager.instance.getReceivingStream(planId);
        if (future == null) {
            logger.info("[Stream #{} ID#{}] Creating new streaming plan for {}", new Object[]{planId, sessionIndex, description});
            future = new StreamResultFuture(planId, description, keepSSTableLevel, isIncremental);
            StreamManager.instance.registerReceiving(future);
        }
        future.attachConnection(from, sessionIndex, connection, isForOutgoing, version);
        logger.info("[Stream #{}, ID#{}] Received streaming plan for {}", new Object[]{planId, sessionIndex, description});
        return future;
    }

    private static StreamResultFuture createAndRegister(UUID planId, String description, StreamCoordinator coordinator) {
        StreamResultFuture future = new StreamResultFuture(planId, description, coordinator);
        StreamManager.instance.register(future);
        return future;
    }

    private void attachConnection(InetAddress from, int sessionIndex, IncomingStreamingConnection connection, boolean isForOutgoing, int version) throws IOException {
        StreamSession session = this.coordinator.getOrCreateSessionById(from, sessionIndex, connection.socket.getInetAddress());
        session.init(this);
        session.handler.initiateOnReceivingSide(connection, isForOutgoing, version);
    }

    public void addEventListener(StreamEventHandler listener) {
        Futures.addCallback((ListenableFuture)this, (FutureCallback)listener);
        this.eventListeners.add(listener);
    }

    public StreamState getCurrentState() {
        return new StreamState(this.planId, this.description, this.coordinator.getAllSessionInfo());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StreamResultFuture that = (StreamResultFuture)((Object)o);
        return this.planId.equals(that.planId);
    }

    public int hashCode() {
        return this.planId.hashCode();
    }

    void handleSessionPrepared(StreamSession session) {
        SessionInfo sessionInfo = session.getSessionInfo();
        logger.info("[Stream #{} ID#{}] Prepare completed. Receiving {} files({} bytes), sending {} files({} bytes)", new Object[]{session.planId(), session.sessionIndex(), sessionInfo.getTotalFilesToReceive(), sessionInfo.getTotalSizeToReceive(), sessionInfo.getTotalFilesToSend(), sessionInfo.getTotalSizeToSend()});
        StreamEvent.SessionPreparedEvent event = new StreamEvent.SessionPreparedEvent(this.planId, sessionInfo);
        this.coordinator.addSessionInfo(sessionInfo);
        this.fireStreamEvent(event);
    }

    void handleSessionComplete(StreamSession session) {
        logger.info("[Stream #{}] Session with {} is complete", (Object)session.planId(), (Object)session.peer);
        this.fireStreamEvent(new StreamEvent.SessionCompleteEvent(session));
        SessionInfo sessionInfo = session.getSessionInfo();
        this.coordinator.addSessionInfo(sessionInfo);
        this.maybeComplete();
    }

    public void handleProgress(ProgressInfo progress) {
        this.coordinator.updateProgress(progress);
        this.fireStreamEvent(new StreamEvent.ProgressEvent(this.planId, progress));
    }

    synchronized void fireStreamEvent(StreamEvent event) {
        for (StreamEventHandler listener : this.eventListeners) {
            listener.handleStreamEvent(event);
        }
    }

    private synchronized void maybeComplete() {
        if (!this.coordinator.hasActiveSessions()) {
            StreamState finalState = this.getCurrentState();
            if (finalState.hasFailedSession()) {
                logger.warn("[Stream #{}] Stream failed", (Object)this.planId);
                this.setException(new StreamException(finalState, "Stream failed"));
            } else {
                logger.info("[Stream #{}] All sessions completed", (Object)this.planId);
                this.set(finalState);
            }
        }
    }
}

