/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.interleaving;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.Query;
import org.apache.solr.ltr.interleaving.Interleaving;
import org.apache.solr.ltr.interleaving.LTRInterleavingRescorer;
import org.apache.solr.ltr.interleaving.LTRInterleavingScoringQuery;
import org.apache.solr.ltr.search.LTRQuery;
import org.apache.solr.search.RankQuery;

public class LTRInterleavingQuery
extends LTRQuery {
    private final LTRInterleavingScoringQuery[] rerankingQueries;
    private final Interleaving interlavingAlgorithm;

    public LTRInterleavingQuery(Interleaving interleavingAlgorithm, LTRInterleavingScoringQuery[] rerankingQueries, int rerankDocs) {
        super(null, rerankDocs, new LTRInterleavingRescorer(interleavingAlgorithm, rerankingQueries));
        this.rerankingQueries = rerankingQueries;
        this.interlavingAlgorithm = interleavingAlgorithm;
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + (this.mainQuery.hashCode() + this.rerankingQueries.hashCode() + this.reRankDocs);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((LTRInterleavingQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(LTRInterleavingQuery other) {
        return this.mainQuery.equals((Object)other.mainQuery) && this.rerankingQueries.equals(other.rerankingQueries) && this.reRankDocs == other.reRankDocs;
    }

    @Override
    public RankQuery wrap(Query _mainQuery) {
        super.wrap(_mainQuery);
        for (LTRInterleavingScoringQuery rerankingQuery : this.rerankingQueries) {
            rerankingQuery.setOriginalQuery(_mainQuery);
        }
        return this;
    }

    @Override
    public String toString(String field) {
        return "{!ltr mainQuery='" + this.mainQuery.toString() + "' rerankingQueries='" + Arrays.toString((Object[])this.rerankingQueries) + "' reRankDocs=" + this.reRankDocs + "}";
    }

    @Override
    protected Query rewrite(Query rewrittenMainQuery) throws IOException {
        return new LTRInterleavingQuery(this.interlavingAlgorithm, this.rerankingQueries, this.reRankDocs).wrap(rewrittenMainQuery);
    }
}

