/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.jdk1_4.gen;

import com.thaiopensource.xml.util.Naming;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

public class NamingExceptionsGen {
    private static final int CHARS_PER_LINE = 10;
    private static final String INDENT = "  ";
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final String NMSTRT_CATEGORIES = "LlLuLoLtNl";
    private static final String NMCHAR_CATEGORIES = "LlLuLoLtNlMcMeMnLmNd";

    public static void main(String[] args) throws IOException {
        String pkg;
        if (args.length != 2) {
            System.err.println("Usage: " + NamingExceptionsGen.class.toString() + " className srcDir");
            System.exit(1);
        }
        String className = args[0];
        String srcDir = args[1];
        int lastDot = className.lastIndexOf(46);
        if (lastDot < 0) {
            pkg = null;
        } else {
            pkg = className.substring(0, lastDot);
            className = className.substring(lastDot + 1);
            srcDir = srcDir + File.separator + pkg.replace('.', File.separatorChar);
        }
        String srcFile = srcDir + File.separator + className + ".java";
        FileOutputStream stm = new FileOutputStream(srcFile);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(stm));
        String lineSep = System.getProperty("line.separator");
        w.write("// This file was automatically generated by ");
        w.write(NamingExceptionsGen.class.getName());
        w.write(lineSep);
        if (pkg != null) {
            w.write("package " + pkg + ";" + lineSep + lineSep);
        }
        w.write("class " + className + " {" + lineSep);
        NamingExceptionsGen.gen(true, w, lineSep);
        NamingExceptionsGen.gen(false, w, lineSep);
        w.write("}" + lineSep);
        ((Writer)w).close();
    }

    private static void gen(boolean isStart, Writer w, String lineSep) throws IOException {
        char[] buf = new char[1];
        boolean excluding = false;
        char excludeMin = '\u0000';
        char excludeMax = '\u0000';
        Vector<Character> includeList = new Vector<Character>();
        Vector<Character> excludeRangeList = new Vector<Character>();
        for (int i = 0; i < 65536; ++i) {
            boolean isName;
            char ch;
            buf[0] = ch = (char)i;
            String s = new String(buf);
            boolean bl = isName = isStart ? Naming.isName(s) : Naming.isNmtoken(s);
            if (isName && excluding) {
                excludeRangeList.add(new Character(excludeMin));
                excludeRangeList.add(new Character(excludeMax));
                excluding = false;
            }
            if (isName == NamingExceptionsGen.isApproxName(ch, isStart)) continue;
            if (isName) {
                includeList.add(new Character(ch));
                continue;
            }
            if (!excluding) {
                excluding = true;
                excludeMin = ch;
            }
            excludeMax = ch;
        }
        if (excluding) {
            excludeRangeList.add(new Character(excludeMin));
            excludeRangeList.add(new Character(excludeMax));
        }
        String prefix = isStart ? "NMSTRT" : "NMCHAR";
        NamingExceptionsGen.genList(prefix + "_INCLUDES", includeList, w, lineSep);
        NamingExceptionsGen.genList(prefix + "_EXCLUDE_RANGES", excludeRangeList, w, lineSep);
        w.write(INDENT);
        w.write("static final String ");
        w.write(prefix);
        w.write("_CATEGORIES = \"");
        w.write(isStart ? NMSTRT_CATEGORIES : NMCHAR_CATEGORIES);
        w.write("\";");
        w.write(lineSep);
    }

    private static void genList(String varName, List includeList, Writer w, String lineSep) throws IOException {
        w.write(INDENT);
        w.write("static final String ");
        w.write(varName);
        w.write(" =");
        w.write(lineSep);
        w.write(INDENT);
        w.write(INDENT);
        w.write(34);
        int len = includeList.size();
        for (int i = 0; i < len; ++i) {
            w.write("\\u");
            w.write(NamingExceptionsGen.hex(((Character)includeList.get(i)).charValue()));
            if (i % 10 != 9 || i + 1 == len) continue;
            w.write("\" +");
            w.write(lineSep);
            w.write(INDENT);
            w.write(INDENT);
            w.write(34);
        }
        w.write("\";");
        w.write(lineSep);
    }

    static String hex(char c) {
        char[] buf = new char[]{HEX_DIGITS.charAt(c >> 12 & 0xF), HEX_DIGITS.charAt(c >> 8 & 0xF), HEX_DIGITS.charAt(c >> 4 & 0xF), HEX_DIGITS.charAt(c & 0xF)};
        return new String(buf);
    }

    private static boolean isApproxName(char c, boolean isStart) {
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                return true;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return !isStart;
            }
        }
        return false;
    }
}

