/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This is the main public HDF5 High Level include file.  Put further
 * information in a particular header file and include that here, don't
 * fill this file with lots of gunk...
 */

#ifndef HDF5_HL_H
#define HDF5_HL_H

#include "hdf5.h"       /* hdf5 main library */
#include "H5DOpublic.h" /* dataset optimization */
#include "H5DSpublic.h" /* dimension scales */
#include "H5LTpublic.h" /* lite */
#include "H5IMpublic.h" /* image */
#include "H5TBpublic.h" /* table */
#include "H5PTpublic.h" /* packet table */
#include "H5LDpublic.h" /* lite dataset */

#endif /*HDF5_HL_H*/
