/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger(JDBCSessionManager.class);
    private ConcurrentHashMap<String, AbstractSession> _sessions;
    protected JDBCSessionIdManager _jdbcSessionIdMgr = null;
    protected long _saveIntervalSec = 60L;

    public void setSaveInterval(long sec) {
        this._saveIntervalSec = sec;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String idInCluster) {
        Session session = (Session)this._sessions.get(idInCluster);
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            try {
                SessionData data = null;
                long now = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    if (session == null) {
                        LOG.debug("getSession(" + idInCluster + "): not in session map," + " now=" + now + " lastSaved=" + (session == null ? 0L : session._data._lastSaved) + " interval=" + this._saveIntervalSec * 1000L, new Object[0]);
                    } else {
                        LOG.debug("getSession(" + idInCluster + "): in session map, " + " now=" + now + " lastSaved=" + (session == null ? 0L : session._data._lastSaved) + " interval=" + this._saveIntervalSec * 1000L + " lastNode=" + session._data.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName() + " difference=" + (now - session._data._lastSaved), new Object[0]);
                    }
                }
                if (session == null || now - session._data._lastSaved >= this._saveIntervalSec * 1000L) {
                    LOG.debug("getSession(" + idInCluster + "): no session in session map or stale session. Reloading session data from db.", new Object[0]);
                    data = this.loadSession(idInCluster, this.canonicalize(this._context.getContextPath()), this.getVirtualHost(this._context));
                } else if (now - session._data._lastSaved >= this._saveIntervalSec * 1000L) {
                    LOG.debug("getSession(" + idInCluster + "): stale session. Reloading session data from db.", new Object[0]);
                    data = this.loadSession(idInCluster, this.canonicalize(this._context.getContextPath()), this.getVirtualHost(this._context));
                } else {
                    LOG.debug("getSession(" + idInCluster + "): session in session map", new Object[0]);
                    data = session._data;
                }
                if (data != null) {
                    if (!data.getLastNode().equals(this.getSessionIdManager().getWorkerName()) || session == null) {
                        if (data._expiryTime <= 0L || data._expiryTime > now) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("getSession(" + idInCluster + "): lastNode=" + data.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName(), new Object[0]);
                            }
                            data.setLastNode(this.getSessionIdManager().getWorkerName());
                            session = new Session(now, data);
                            this._sessions.put(idInCluster, session);
                            session.didActivate();
                            this.updateSessionNode(data);
                        } else {
                            LOG.debug("getSession ({}): Session has expired", new Object[]{idInCluster});
                        }
                    } else {
                        LOG.debug("getSession({}): Session not stale {}", new Object[]{idInCluster, session._data});
                    }
                } else {
                    session = null;
                    LOG.debug("getSession({}): No session in database matching id={}", new Object[]{idInCluster, idInCluster});
                }
                return session;
            }
            catch (Exception e) {
                LOG.warn("Unable to load session from database", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessions() {
        int size = 0;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            size = this._sessions.size();
        }
        return size;
    }

    @Override
    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this._jdbcSessionIdMgr = (JDBCSessionIdManager)this._sessionIdManager;
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        this._sessions.clear();
        this._sessions = null;
        super.doStop();
    }

    @Override
    protected void invalidateSessions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            session = (Session)this._sessions.get(idInCluster);
        }
        if (session != null) {
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeSession(String idInCluster) {
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            Session session = (Session)this._sessions.remove(idInCluster);
            try {
                if (session != null) {
                    this.deleteSession(session._data);
                }
            }
            catch (Exception e) {
                LOG.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
            }
            return session != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            this._sessions.put(session.getClusterId(), session);
        }
        try {
            session.willPassivate();
            this.storeSession(((Session)session)._data);
            session.didActivate();
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), (Throwable)e);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = false;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            if (this.getSession(session.getClusterId()) != null) {
                removed = true;
                this.removeSession(session.getClusterId());
            }
        }
        if (removed) {
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && !this._sessionListeners.isEmpty()) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener l : this._sessionListeners) {
                    l.sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(List<?> sessionIds) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        ListIterator<?> itor = sessionIds.listIterator();
        try {
            try {
                while (itor.hasNext()) {
                    Session session;
                    String sessionId = (String)itor.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Expiring session id " + sessionId, new Object[0]);
                    }
                    if ((session = (Session)this._sessions.get(sessionId)) != null) {
                        session.timeout();
                        itor.remove();
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Unrecognized session id=" + sessionId, new Object[0]);
                }
                Object var8_8 = null;
                thread.setContextClassLoader(old_loader);
            }
            catch (Throwable t) {
                LOG.warn("Problem expiring sessions", t);
                Object var8_9 = null;
                thread.setContextClassLoader(old_loader);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            thread.setContextClassLoader(old_loader);
            throw throwable;
        }
    }

    protected SessionData loadSession(final String id, final String canonicalContextPath, final String vhost) throws Exception {
        final AtomicReference _reference = new AtomicReference();
        final AtomicReference _exception = new AtomicReference();
        Runnable load = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                SessionData data = null;
                Connection connection = null;
                PreparedStatement statement = null;
                connection = JDBCSessionManager.this.getConnection();
                statement = JDBCSessionManager.this._jdbcSessionIdMgr._dbAdaptor.getLoadStatement(connection, id, canonicalContextPath, vhost);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    data = new SessionData(id);
                    data.setRowId(result.getString(JDBCSessionManager.this._jdbcSessionIdMgr._sessionTableRowId));
                    data.setCookieSet(result.getLong("cookieTime"));
                    data.setLastAccessed(result.getLong("lastAccessTime"));
                    data.setAccessed(result.getLong("accessTime"));
                    data.setCreated(result.getLong("createTime"));
                    data.setLastNode(result.getString("lastNode"));
                    data.setLastSaved(result.getLong("lastSavedTime"));
                    data.setExpiryTime(result.getLong("expiryTime"));
                    data.setCanonicalContext(result.getString("contextPath"));
                    data.setVirtualHost(result.getString("virtualHost"));
                    InputStream is = ((JDBCSessionIdManager)JDBCSessionManager.this.getSessionIdManager())._dbAdaptor.getBlobInputStream(result, "map");
                    ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);
                    Object o = ois.readObject();
                    data.setAttributeMap((Map)o);
                    ois.close();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("LOADED session " + data, new Object[0]);
                    }
                }
                _reference.set(data);
                Object var9_9 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception e2) {
                    LOG.warn((Throwable)e2);
                }
                return;
                {
                    catch (Exception e) {
                        _exception.set(e);
                        Object var9_10 = null;
                        if (connection == null) return;
                        try {
                            connection.close();
                            return;
                        }
                        catch (Exception e2) {
                            LOG.warn((Throwable)e2);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (connection == null) throw throwable;
                    try {
                        connection.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        LOG.warn((Throwable)e2);
                    }
                    throw throwable;
                }
            }
        };
        if (this._context == null) {
            load.run();
        } else {
            this._context.getContextHandler().handle(load);
        }
        if (_exception.get() != null) {
            throw (Exception)_exception.get();
        }
        return (SessionData)_reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            String rowId = this.calculateRowId(data);
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._insertSession);
            statement.setString(1, rowId);
            statement.setString(2, data.getId());
            statement.setString(3, data.getCanonicalContext());
            statement.setString(4, data.getVirtualHost());
            statement.setString(5, this.getSessionIdManager().getWorkerName());
            statement.setLong(6, data.getAccessed());
            statement.setLong(7, data.getLastAccessed());
            statement.setLong(8, data.getCreated());
            statement.setLong(9, data.getCookieSet());
            statement.setLong(10, now);
            statement.setLong(11, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(12, (InputStream)bais, bytes.length);
            statement.executeUpdate();
            data.setRowId(rowId);
            data.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stored session " + data, new Object[0]);
            }
            Object var12_10 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSession);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(6, (InputStream)bais, bytes.length);
            statement.setString(7, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session " + data, new Object[0]);
            }
            Object var11_9 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSessionNode(SessionData data) throws Exception {
        String nodeId = this.getSessionIdManager().getWorkerName();
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionNode);
            statement.setString(1, nodeId);
            statement.setString(2, data.getRowId());
            statement.executeUpdate();
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated last node for session id=" + data.getId() + ", lastNode = " + nodeId, new Object[0]);
            }
            Object var6_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSessionAccessTime(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionAccessTime);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            statement.setString(6, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated access time session id=" + data.getId(), new Object[0]);
            }
            Object var7_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteSession(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._deleteSession);
            statement.setString(1, data.getRowId());
            statement.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted Session " + data, new Object[0]);
            }
            Object var5_4 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    private Connection getConnection() throws SQLException {
        return ((JDBCSessionIdManager)this.getSessionIdManager()).getConnection();
    }

    private String calculateRowId(SessionData data) {
        String rowId = this.canonicalize(this._context.getContextPath());
        rowId = rowId + "_" + this.getVirtualHost(this._context);
        rowId = rowId + "_" + data.getId();
        return rowId;
    }

    private String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }

    public class Session
    extends AbstractSession {
        private static final long serialVersionUID = 5208464051134226143L;
        private final SessionData _data;
        private boolean _dirty;

        protected Session(HttpServletRequest request) {
            super(JDBCSessionManager.this, request);
            this._dirty = false;
            this._data = new SessionData(this.getClusterId(), this.getAttributeMap());
            if (JDBCSessionManager.this._dftMaxIdleSecs > 0) {
                this._data.setMaxIdleMs((long)JDBCSessionManager.this._dftMaxIdleSecs * 1000L);
            }
            this._data.setCanonicalContext(JDBCSessionManager.this.canonicalize(JDBCSessionManager.this._context.getContextPath()));
            this._data.setVirtualHost(JDBCSessionManager.this.getVirtualHost(JDBCSessionManager.this._context));
            int maxInterval = this.getMaxInactiveInterval();
            this._data.setExpiryTime(maxInterval <= 0 ? 0L : System.currentTimeMillis() + (long)maxInterval * 1000L);
        }

        protected Session(long accessed, SessionData data) {
            super(JDBCSessionManager.this, data.getCreated(), accessed, data.getId());
            this._dirty = false;
            this._data = data;
            if (JDBCSessionManager.this._dftMaxIdleSecs > 0) {
                this._data.setMaxIdleMs((long)JDBCSessionManager.this._dftMaxIdleSecs * 1000L);
            }
            this.addAttributes(this._data.getAttributeMap());
            this._data.setAttributeMap(this.getAttributeMap());
        }

        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            this._dirty = true;
        }

        public void removeAttribute(String name) {
            super.removeAttribute(name);
            this._dirty = true;
        }

        protected void cookieSet() {
            this._data.setCookieSet(this._data.getAccessed());
        }

        protected boolean access(long time) {
            if (super.access(time)) {
                this._data.setLastAccessed(this._data.getAccessed());
                this._data.setAccessed(time);
                int maxInterval = this.getMaxInactiveInterval();
                this._data.setExpiryTime(maxInterval <= 0 ? 0L : time + (long)maxInterval * 1000L);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            super.complete();
            try {
                block5: {
                    try {
                        if (this._dirty) {
                            this.willPassivate();
                            JDBCSessionManager.this.updateSession(this._data);
                            this.didActivate();
                            break block5;
                        }
                        if (this._data._accessed - this._data._lastSaved < JDBCSessionManager.this.getSaveInterval() * 1000L) break block5;
                        JDBCSessionManager.this.updateSessionAccessTime(this._data);
                    }
                    catch (Exception e) {
                        LOG.warn("Problem persisting changed session data id=" + this.getId(), (Throwable)e);
                        Object var3_2 = null;
                        this._dirty = false;
                    }
                }
                Object var3_1 = null;
                this._dirty = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._dirty = false;
                throw throwable;
            }
        }

        protected void timeout() throws IllegalStateException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out session id=" + this.getClusterId(), new Object[0]);
            }
            super.timeout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SessionData {
        private final String _id;
        private String _rowId;
        private long _accessed;
        private long _lastAccessed;
        private long _maxIdleMs = -1L;
        private long _cookieSet;
        private long _created;
        private Map<String, Object> _attributes;
        private String _lastNode;
        private String _canonicalContext;
        private long _lastSaved;
        private long _expiryTime;
        private String _virtualHost;

        public SessionData(String sessionId) {
            this._id = sessionId;
            this._accessed = this._created = System.currentTimeMillis();
            this._attributes = new HashMap<String, Object>();
            this._lastNode = JDBCSessionManager.this.getSessionIdManager().getWorkerName();
        }

        public SessionData(String sessionId, Map<String, Object> attributes) {
            this._id = sessionId;
            this._accessed = this._created = System.currentTimeMillis();
            this._attributes = attributes;
            this._lastNode = JDBCSessionManager.this.getSessionIdManager().getWorkerName();
        }

        public synchronized String getId() {
            return this._id;
        }

        public synchronized long getCreated() {
            return this._created;
        }

        protected synchronized void setCreated(long ms) {
            this._created = ms;
        }

        public synchronized long getAccessed() {
            return this._accessed;
        }

        protected synchronized void setAccessed(long ms) {
            this._accessed = ms;
        }

        public synchronized void setMaxIdleMs(long ms) {
            this._maxIdleMs = ms;
        }

        public synchronized long getMaxIdleMs() {
            return this._maxIdleMs;
        }

        public synchronized void setLastAccessed(long ms) {
            this._lastAccessed = ms;
        }

        public synchronized long getLastAccessed() {
            return this._lastAccessed;
        }

        public void setCookieSet(long ms) {
            this._cookieSet = ms;
        }

        public synchronized long getCookieSet() {
            return this._cookieSet;
        }

        public synchronized void setRowId(String rowId) {
            this._rowId = rowId;
        }

        protected synchronized String getRowId() {
            return this._rowId;
        }

        protected synchronized Map<String, Object> getAttributeMap() {
            return this._attributes;
        }

        protected synchronized void setAttributeMap(Map<String, Object> map) {
            this._attributes = map;
        }

        public synchronized void setLastNode(String node) {
            this._lastNode = node;
        }

        public synchronized String getLastNode() {
            return this._lastNode;
        }

        public synchronized void setCanonicalContext(String str) {
            this._canonicalContext = str;
        }

        public synchronized String getCanonicalContext() {
            return this._canonicalContext;
        }

        public synchronized long getLastSaved() {
            return this._lastSaved;
        }

        public synchronized void setLastSaved(long time) {
            this._lastSaved = time;
        }

        public synchronized void setExpiryTime(long time) {
            this._expiryTime = time;
        }

        public synchronized long getExpiryTime() {
            return this._expiryTime;
        }

        public synchronized void setVirtualHost(String vhost) {
            this._virtualHost = vhost;
        }

        public synchronized String getVirtualHost() {
            return this._virtualHost;
        }

        public String toString() {
            return "Session rowId=" + this._rowId + ",id=" + this._id + ",lastNode=" + this._lastNode + ",created=" + this._created + ",accessed=" + this._accessed + ",lastAccessed=" + this._lastAccessed + ",cookieSet=" + this._cookieSet + "lastSaved=" + this._lastSaved;
        }
    }
}

