/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.AWTUtilities;
import free.util.Localization;
import free.util.PlatformUtils;
import free.util.swing.AdvancedJDesktopPane;
import free.util.swing.ExtensionFileFilter;
import free.util.swing.LocalizationService;
import free.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BackgroundChooser
extends JDialog {
    private static Localization l10n;
    private final AdvancedJDesktopPane desktop;
    private final Color defaultColor;
    private final File defaultImageFile;
    private final int defaultImageLayoutStyle;
    private Color color;
    private File imageFile;
    private int imageLayoutStyle;

    public BackgroundChooser(Frame frame, AdvancedJDesktopPane advancedJDesktopPane, Color color, File file, int n, Color color2, File file2, int n2) {
        super(frame, BackgroundChooser.getL10n().getString("title"), true);
        this.desktop = advancedJDesktopPane;
        this.defaultColor = color;
        this.defaultImageFile = file;
        this.defaultImageLayoutStyle = n;
        this.color = color2;
        this.imageFile = file2;
        this.imageLayoutStyle = n2;
        this.createUI();
        this.setDefaultCloseOperation(2);
        SwingUtils.registerEscapeCloser(this);
    }

    private static synchronized Localization getL10n() {
        if (l10n == null) {
            l10n = LocalizationService.getForClass(BackgroundChooser.class);
        }
        return l10n;
    }

    private void createUI() {
        boolean bl = this.hasAccessToFileSystem();
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        this.setContentPane(jPanel);
        jPanel.setBorder(new EmptyBorder(15, 10, 15, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(bl ? 4 : 2, 1, 10, 10));
        jPanel2.setBorder(new EmptyBorder(0, 10, 0, 10));
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        SwingUtils.applyLabelSpec(jButton, BackgroundChooser.getL10n().getString("pickColorButton.text"));
        SwingUtils.applyLabelSpec(jButton2, BackgroundChooser.getL10n().getString("pickImageButton.text"));
        SwingUtils.applyLabelSpec(jButton3, BackgroundChooser.getL10n().getString("useDefaultsButton.text"));
        jButton.setDefaultCapable(false);
        jButton2.setDefaultCapable(false);
        jButton3.setDefaultCapable(false);
        final JRadioButton jRadioButton = new JRadioButton();
        final JRadioButton jRadioButton2 = new JRadioButton();
        final JRadioButton jRadioButton3 = new JRadioButton();
        SwingUtils.applyLabelSpec(jRadioButton, BackgroundChooser.getL10n().getString("tileRadioButton.text"));
        SwingUtils.applyLabelSpec(jRadioButton2, BackgroundChooser.getL10n().getString("scaleRadioButton.text"));
        SwingUtils.applyLabelSpec(jRadioButton3, BackgroundChooser.getL10n().getString("centerRadioButton.text"));
        switch (this.imageLayoutStyle) {
            case 2: {
                jRadioButton.setSelected(true);
                break;
            }
            case 3: {
                jRadioButton2.setSelected(true);
                break;
            }
            case 1: {
                jRadioButton3.setSelected(true);
            }
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 5, 0));
        jPanel3.add(jRadioButton);
        jPanel3.add(jRadioButton2);
        jPanel3.add(jRadioButton3);
        jPanel2.add(jButton);
        if (bl) {
            jPanel2.add(jButton2);
            jPanel2.add(jPanel3);
        }
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton(BackgroundChooser.getL10n().getString("closeButton.text"));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 1));
        jPanel4.setBorder(new EmptyBorder(0, 10, 0, 10));
        jPanel4.add(jButton4);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JSeparator(), "Center");
        jPanel.add((Component)jPanel4, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JColorChooser jColorChooser = BackgroundChooser.this.createColorChooser();
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Color color = jColorChooser.getColor();
                        if (color != null) {
                            BackgroundChooser.this.color = color;
                        }
                        if (BackgroundChooser.this.color == null) {
                            BackgroundChooser.this.desktop.setBackground(UIManager.getColor("desktop"));
                        } else {
                            BackgroundChooser.this.desktop.setBackground(BackgroundChooser.this.color);
                        }
                    }
                };
                ActionListener actionListener2 = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (BackgroundChooser.this.color == null) {
                            BackgroundChooser.this.desktop.setBackground(UIManager.getColor("desktop"));
                        } else {
                            BackgroundChooser.this.desktop.setBackground(BackgroundChooser.this.color);
                        }
                    }
                };
                JDialog jDialog = JColorChooser.createDialog(BackgroundChooser.this, BackgroundChooser.getL10n().getString("bgColorChooser.title"), true, jColorChooser, actionListener, actionListener2);
                jDialog.setVisible(true);
            }
        });
        if (bl) {
            final JFileChooser jFileChooser = this.createImageFileChooser();
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    int n = jFileChooser.showOpenDialog(BackgroundChooser.this);
                    File file2 = file = n == 0 ? jFileChooser.getSelectedFile() : null;
                    if (file != null && file.exists()) {
                        BackgroundChooser.this.imageFile = file;
                    }
                    if (BackgroundChooser.this.imageFile == null) {
                        BackgroundChooser.this.desktop.setWallpaper(null);
                    } else {
                        BackgroundChooser.this.desktop.setWallpaper(BackgroundChooser.this.desktop.getToolkit().getImage(BackgroundChooser.this.imageFile.getAbsolutePath()));
                    }
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BackgroundChooser.this.color = BackgroundChooser.this.defaultColor;
                    BackgroundChooser.this.imageFile = BackgroundChooser.this.defaultImageFile;
                    BackgroundChooser.this.imageLayoutStyle = BackgroundChooser.this.defaultImageLayoutStyle;
                    if (BackgroundChooser.this.color == null) {
                        BackgroundChooser.this.desktop.setBackground(UIManager.getColor("desktop"));
                    } else {
                        BackgroundChooser.this.desktop.setBackground(BackgroundChooser.this.color);
                    }
                    if (BackgroundChooser.this.imageFile == null) {
                        BackgroundChooser.this.desktop.setWallpaper(null);
                    } else {
                        BackgroundChooser.this.desktop.setWallpaper(BackgroundChooser.this.desktop.getToolkit().getImage(BackgroundChooser.this.imageFile.getAbsolutePath()));
                    }
                    BackgroundChooser.this.desktop.setWallpaperLayoutStyle(BackgroundChooser.this.imageLayoutStyle);
                    switch (BackgroundChooser.this.imageLayoutStyle) {
                        case 1: {
                            jRadioButton3.setSelected(true);
                            break;
                        }
                        case 2: {
                            jRadioButton.setSelected(true);
                            break;
                        }
                        case 3: {
                            jRadioButton2.setSelected(true);
                        }
                    }
                }
            });
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object == jRadioButton) {
                        BackgroundChooser.this.imageLayoutStyle = 2;
                    } else if (object == jRadioButton2) {
                        BackgroundChooser.this.imageLayoutStyle = 3;
                    } else if (object == jRadioButton3) {
                        BackgroundChooser.this.imageLayoutStyle = 1;
                    }
                    BackgroundChooser.this.desktop.setWallpaperLayoutStyle(BackgroundChooser.this.imageLayoutStyle);
                }
            };
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            jRadioButton3.addActionListener(actionListener);
        }
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundChooser.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton4);
    }

    private boolean hasAccessToFileSystem() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(System.getProperty("user.home"));
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private JColorChooser createColorChooser() {
        final JColorChooser jColorChooser = new JColorChooser(this.desktop.getBackground());
        jColorChooser.setPreviewPanel(new JPanel());
        jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Color color = jColorChooser.getColor();
                if (color != null) {
                    BackgroundChooser.this.desktop.setBackground(color);
                }
            }
        });
        return jColorChooser;
    }

    private JFileChooser createImageFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        String[] stringArray = PlatformUtils.isJavaBetterThan("1.3") ? new String[]{".gif", ".jpg", ".jpeg", ".png"} : new String[]{".gif", ".jpg", ".jpeg"};
        jFileChooser.setFileFilter(new ExtensionFileFilter(BackgroundChooser.getL10n().getString("fileFilterName"), stringArray, false));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file;
                String string = propertyChangeEvent.getPropertyName();
                if ("SelectedFileChangedProperty".equals(string) && (file = (File)propertyChangeEvent.getNewValue()) != null) {
                    Image image = BackgroundChooser.this.desktop.getToolkit().getImage(file.getAbsolutePath());
                    BackgroundChooser.this.desktop.setWallpaper(image);
                }
            }
        });
        return jFileChooser;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            AWTUtilities.centerWindow(this, this.getParent());
        }
        super.setVisible(bl);
    }

    public Color getColor() {
        return this.color;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public int getImageLayoutStyle() {
        return this.imageLayoutStyle;
    }
}

