#!/bin/sh
#
# This filter is called by psf to convert "other" formats to PostScript.
# psf handles text and PostScript native.  "Other" formats, e.g. DVI, C/A/T,
# need to be converted before the page reverser and the printer can use
# them.
#
# $0 begins with the filter name, e.g. df, tf.  Each format is a separate
# tag in the case.
#

DVIPS="/usr/pkg/bin/dvips"
DVIPSARGS="-f -q"

GROFF="/usr/bin/groff"
TROFF2PSARGS="-Tps"

case $1 in

#
# Use "dvips" to convert TeX DVI files to PostScript.
# Note that you *must* have METAFONT, etc, in your path.
#
df*)
    if [ -x "$DVIPS" ]; then
	TEMPFILE=`mktemp -t psfilter.XXXXXX` || exit 1
	cat > $TEMPFILE
	$DVIPS $DVIPSARGS < $TEMPFILE
	rm -f $TEMPFILE
    else
	echo "$0: filter dvips not installed" 1>&2
	exit 2
    fi
    ;;

#
# Use GNU groff(1) to convert roff to ps
#
tf*)
    if [ -x "$GROFF" ]; then
	exec $GROFF $TROFF2PSARGS
    else
	echo "$0: filter troff2ps not installed" 1>&2
	exit 2
    fi
    ;;

*)
    echo "$0: filter $1 unavailable" 1>&2
    exit 2
    ;;
esac

exit 0
