/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class PathTokenizer
extends Tokenizer {
    public static final char DEFAULT_DELIMITER = '/';
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int startPosition = 0;
    private final char delimiter = (char)47;
    private int charsRead = 0;
    private boolean dot = false;
    private static final char cdot = '.';

    public PathTokenizer(Reader input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        int c;
        this.clearAttributes();
        if (this.dot) {
            this.dot = false;
            this.termAtt.setEmpty();
            this.termAtt.append('.');
            this.termAtt.setLength(1);
            this.offsetAtt.setOffset(this.correctOffset(this.startPosition), this.correctOffset(this.startPosition + 1));
            ++this.startPosition;
            return true;
        }
        char[] buf = new char[64];
        int i = 0;
        do {
            c = this.input.read();
            ++this.charsRead;
            if (c != -1) continue;
            return false;
        } while (c == this.delimiter);
        do {
            if (i >= buf.length) {
                buf = Arrays.copyOf(buf, buf.length * 2);
            }
            buf[i++] = Character.toLowerCase((char)c);
            c = this.input.read();
            ++this.charsRead;
        } while (c != this.delimiter && c != 46 && !Character.isWhitespace(c) && c != -1);
        if (c == 46) {
            this.dot = true;
        }
        this.termAtt.copyBuffer(buf, 0, i);
        this.termAtt.setLength(i);
        this.offsetAtt.setOffset(this.correctOffset(this.startPosition), this.correctOffset(this.startPosition + i));
        this.startPosition = this.startPosition + i + 1;
        return true;
    }

    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.charsRead);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.dot = false;
        this.charsRead = 0;
        this.startPosition = 0;
    }

    public final void close() throws IOException {
        super.close();
    }
}

