/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import org.apache.commons.jrcs.rcs.BranchNotFoundException;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.Version;

class BranchNode
extends Node {
    BranchNode(Version version, BranchNode branchNode) {
        super(version, branchNode);
        if (version == null) {
            throw new IllegalArgumentException(version.toString());
        }
    }

    public BranchNode getLeafNode() {
        BranchNode branchNode = this;
        while (branchNode.getRCSNext() != null) {
            branchNode = (BranchNode)branchNode.getRCSNext();
        }
        return branchNode;
    }

    public void setRCSNext(Node node) {
        super.setRCSNext(node);
        if (this.getChild() != null) {
            this.getChild().parent = null;
        }
        this.child = node;
        if (this.getChild() != null) {
            this.getChild().parent = this;
        }
    }

    public Node deltaRevision() {
        return this;
    }

    public Node nextInPathTo(Version version, boolean bl) throws NodeNotFoundException {
        Version version2 = version.getBase(this.version.size());
        Version version3 = this.version.getBase(version2.size());
        if (version3.isGreaterThan(version2) && !bl) {
            throw new NodeNotFoundException(version);
        }
        if (this.version.equals(version)) {
            return null;
        }
        if (this.version.isLessThan(version2)) {
            return this.getChild();
        }
        if (version.size() <= this.version.size()) {
            if (version.size() < this.version.size() || version2.last() == 0) {
                return this.getChild();
            }
            return null;
        }
        BranchNode branchNode = this.getBranch(version.at(this.version.size()));
        if (branchNode != null || bl) {
            return branchNode;
        }
        throw new BranchNotFoundException(version.getBase(this.version.size() + 1));
    }
}

