/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class Alert
implements Comparable {
    public static final int RISK_INFO = 0;
    public static final int RISK_LOW = 1;
    public static final int RISK_MEDIUM = 2;
    public static final int RISK_HIGH = 3;
    public static final int SUSPICIOUS = 0;
    public static final int WARNING = 1;
    public static final String[] MSG_RISK = new String[]{"Informational", "Low", "Medium", "High"};
    public static final String[] MSG_RELIABILITY = new String[]{"Suspicious", "Warning"};
    private int alertId = 0;
    private int pluginId = 0;
    private String alert = "";
    private int risk = 0;
    private int reliability = 1;
    private String description = "";
    private String uri = "";
    private String param = "";
    private String otherInfo = "";
    private String solution = "";
    private String reference = "";
    private HttpMessage message = null;

    public Alert(int n) {
        this.pluginId = n;
    }

    public Alert(int n, int n2, int n3, String string) {
        this(n);
        this.setRiskReliability(n2, n3);
        this.setAlert(string);
    }

    public Alert(RecordAlert recordAlert) {
        this(recordAlert.getPluginId(), recordAlert.getRisk(), recordAlert.getReliability(), recordAlert.getAlert());
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(recordAlert.getHistoryId());
            this.setDetail(recordAlert.getDescription(), recordAlert.getUri(), recordAlert.getParam(), recordAlert.getOtherInfo(), recordAlert.getSolution(), recordAlert.getReference(), historyReference.getHttpMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setRiskReliability(int n, int n2) {
        this.risk = n;
        this.reliability = n2;
    }

    public void setAlert(String string) {
        if (string == null) {
            return;
        }
        this.alert = new String(string);
    }

    public void setDetail(String string, String string2, String string3, String string4, String string5, String string6, HttpMessage httpMessage) {
        this.setDescription(string);
        this.setUri(string2);
        this.setParam(string3);
        this.setOtherInfo(string4);
        this.setSolution(string5);
        this.setReference(string6);
        this.setMessage(httpMessage);
    }

    public void setUri(String string) {
        this.uri = new String(string);
    }

    public void setDescription(String string) {
        if (string == null) {
            return;
        }
        this.description = new String(string);
    }

    public void setParam(String string) {
        if (string == null) {
            return;
        }
        this.param = new String(string);
    }

    public void setOtherInfo(String string) {
        if (string == null) {
            return;
        }
        this.otherInfo = new String(string);
    }

    public void setSolution(String string) {
        if (string == null) {
            return;
        }
        this.solution = new String(string);
    }

    public void setReference(String string) {
        if (string == null) {
            return;
        }
        this.reference = new String(string);
    }

    public void setMessage(HttpMessage httpMessage) {
        this.message = httpMessage != null ? httpMessage.cloneAll() : httpMessage;
    }

    public int compareTo(Object object) throws ClassCastException {
        Alert alert = (Alert)object;
        int n = 0;
        if (this.risk < alert.risk) {
            return -1;
        }
        if (this.risk > alert.risk) {
            return 1;
        }
        if (this.reliability < alert.reliability) {
            return -1;
        }
        if (this.reliability > alert.reliability) {
            return 1;
        }
        n = this.alert.compareToIgnoreCase(alert.alert);
        if (n != 0) {
            return n;
        }
        n = this.alert.compareToIgnoreCase(alert.uri);
        if (n != 0) {
            return n;
        }
        n = this.alert.compareToIgnoreCase(alert.param);
        if (n != 0) {
            return n;
        }
        return this.otherInfo.compareToIgnoreCase(alert.otherInfo);
    }

    public boolean equals(Object object) {
        Alert alert = null;
        if (object instanceof Alert) {
            alert = (Alert)object;
            if (this.pluginId == alert.pluginId && this.uri.equalsIgnoreCase(alert.uri) && this.param.equalsIgnoreCase(alert.param) && this.otherInfo.equalsIgnoreCase(alert.otherInfo)) {
                return true;
            }
        }
        return false;
    }

    public Alert newInstance() {
        Alert alert = new Alert(this.pluginId);
        alert.setRiskReliability(this.risk, this.reliability);
        alert.setAlert(this.alert);
        alert.setDetail(this.description, this.uri, this.param, this.otherInfo, this.solution, this.reference, this.message);
        return alert;
    }

    public String toPluginXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append("<alertitem>\r\n");
        stringBuffer.append("  <pluginid>" + this.pluginId + "</pluginid>\r\n");
        stringBuffer.append("  <alert>" + this.alert + "</alert>\r\n");
        stringBuffer.append("  <riskcode>" + this.risk + "</riskcode>\r\n");
        stringBuffer.append("  <reliability>" + this.reliability + "</reliability>\r\n");
        stringBuffer.append("  <riskdesc>" + this.replaceEntity(MSG_RISK[this.risk] + " (" + MSG_RELIABILITY[this.reliability] + ")") + "</riskdesc>\r\n");
        stringBuffer.append("  <desc>" + this.paragraph(this.replaceEntity(this.description)) + "</desc>\r\n");
        stringBuffer.append(string);
        stringBuffer.append("  <solution>" + this.paragraph(this.replaceEntity(this.solution)) + "</solution>\r\n");
        stringBuffer.append("  <reference>" + this.paragraph(this.replaceEntity(this.reference)) + "</reference>\r\n");
        stringBuffer.append("</alertitem>\r\n");
        return stringBuffer.toString();
    }

    public String replaceEntity(String string) {
        String string2 = null;
        if (string != null) {
            string2 = ReportGenerator.entityEncode(string);
        }
        return string2;
    }

    public String paragraph(String string) {
        String string2 = null;
        string2 = "<p>" + string.replaceAll("\\r\\n", "</p><p>").replaceAll("\\n", "</p><p>") + "</p>";
        string2 = string2.replaceAll("&lt;ul&gt;", "<ul>").replaceAll("&lt;/ul&gt;", "</ul>").replaceAll("&lt;li&gt;", "<li>").replaceAll("&lt;/li&gt;", "</li>");
        return string2;
    }

    private String breakNoSpaceString(String string) {
        String string2 = null;
        string2 = string.replaceAll("&amp;", "&amp;<wbr/>");
        return string2;
    }

    public String getAlert() {
        return this.alert;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPluginId() {
        return this.pluginId;
    }

    public HttpMessage getMessage() {
        return this.message;
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public String getParam() {
        return this.param;
    }

    public String getReference() {
        return this.reference;
    }

    public int getReliability() {
        return this.reliability;
    }

    public int getRisk() {
        return this.risk;
    }

    public String getSolution() {
        return this.solution;
    }

    public String getUri() {
        return this.uri;
    }

    public int getAlertId() {
        return this.alertId;
    }

    public void setAlertId(int n) {
        this.alertId = n;
    }

    public String getUrlParamXML() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("  <uri>" + this.breakNoSpaceString(this.replaceEntity(this.uri)) + "</uri>\r\n");
        stringBuffer.append("  <param>" + this.breakNoSpaceString(this.replaceEntity(this.param)) + "</param>\r\n");
        stringBuffer.append("  <otherinfo>" + this.breakNoSpaceString(this.replaceEntity(this.otherInfo)) + "</otherinfo>\r\n");
        return stringBuffer.toString();
    }
}

