/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class Animator
implements ActionListener {
    private final Component _source;
    private Timer _timer;
    private final int _totalSteps;
    private int _currentStep;
    private EventListenerList _listenerList = new EventListenerList();

    public Animator(Component source) {
        this(source, 50, 10, 10);
    }

    public Animator(Component source, int initDelay, int delay, int totalSteps) {
        this._source = source;
        this._totalSteps = totalSteps;
        this._timer = this.createTimer(delay, this);
        this._timer.setInitialDelay(initDelay);
    }

    protected Timer createTimer(int delay, ActionListener listener) {
        return new Timer(delay, listener);
    }

    public void addAnimatorListener(AnimatorListener l) {
        this._listenerList.add(AnimatorListener.class, l);
    }

    public void removeAnimatorListener(AnimatorListener l) {
        this._listenerList.remove(AnimatorListener.class, l);
    }

    public AnimatorListener[] getAnimatorListeners() {
        return (AnimatorListener[])this._listenerList.getListeners(AnimatorListener.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._source != null) {
            AnimatorListener[] listeners;
            if (this._listenerList != null) {
                for (AnimatorListener listener : listeners = this.getAnimatorListeners()) {
                    listener.animationFrame(this._source, this._totalSteps, this._currentStep);
                }
            }
            ++this._currentStep;
            if (this._totalSteps != -1 && this._currentStep > this._totalSteps) {
                this.stop();
                if (this._listenerList != null) {
                    for (AnimatorListener listener : listeners = this.getAnimatorListeners()) {
                        listener.animationEnds(this._source);
                    }
                }
            }
        }
    }

    public void start() {
        if (this._listenerList != null) {
            AnimatorListener[] listeners;
            for (AnimatorListener listener : listeners = this.getAnimatorListeners()) {
                listener.animationStarts(this._source);
            }
        }
        if (this._timer != null) {
            this._timer.start();
        }
        this._currentStep = 0;
    }

    public void stop() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._currentStep = 0;
    }

    public void interrupt() {
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public boolean isRunning() {
        return this._timer != null && this._timer.isRunning();
    }

    public void setDelay(int delay) {
        this._timer.setDelay(delay);
    }

    public void dispose() {
        this.stop();
        this._timer.removeActionListener(this);
        this._timer = null;
    }
}

