/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

class ScrollPaneOverview
extends JComponent {
    private static final int MAX_SIZE = 400;
    private Component _owner;
    private JScrollPane _scrollPane;
    private Component _viewComponent;
    private JPopupMenu _popupMenu;
    private BufferedImage _image;
    private Rectangle _startRectangle;
    private Rectangle _rectangle;
    private Point _startPoint;
    private double _scale;
    private Color _selectionBorder;

    public ScrollPaneOverview(JScrollPane scrollPane, Component owner) {
        this._scrollPane = scrollPane;
        this._owner = owner;
        this._image = null;
        this._startRectangle = null;
        this._rectangle = null;
        this._startPoint = null;
        this._scale = 0.0;
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(13));
        MouseInputAdapter mil = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ScrollPaneOverview.this._startPoint != null) {
                    Point newPoint = e.getPoint();
                    int deltaX = (int)((double)(newPoint.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x) / ScrollPaneOverview.this._scale);
                    int deltaY = (int)((double)(newPoint.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y) / ScrollPaneOverview.this._scale);
                    ScrollPaneOverview.this.scroll(deltaX, deltaY);
                }
                ScrollPaneOverview.this._startPoint = null;
                ScrollPaneOverview.this._startRectangle = ScrollPaneOverview.this._rectangle;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ScrollPaneOverview.this._startPoint == null) {
                    ScrollPaneOverview.this._startPoint = new Point(((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.x + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.width / 2, ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.y + ((ScrollPaneOverview)ScrollPaneOverview.this)._rectangle.height / 2);
                }
                Point newPoint = e.getPoint();
                ScrollPaneOverview.this.moveRectangle(newPoint.x - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.x, newPoint.y - ((ScrollPaneOverview)ScrollPaneOverview.this)._startPoint.y);
            }
        };
        this.addMouseListener(mil);
        this.addMouseMotionListener(mil);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.setLayout(new BorderLayout());
        this._popupMenu.add((Component)this, "Center");
    }

    public void setSelectionBorderColor(Color selectionBorder) {
        this._selectionBorder = selectionBorder;
    }

    public Color getSelectionBorder() {
        return this._selectionBorder;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._image == null || this._rectangle == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Insets insets = this.getInsets();
        int xOffset = insets.left;
        int yOffset = insets.top;
        g.setColor(this._scrollPane.getViewport().getView().getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this._image, xOffset, yOffset, null);
        int availableWidth = this.getWidth() - insets.left - insets.right;
        int availableHeight = this.getHeight() - insets.top - insets.bottom;
        Area area = new Area(new Rectangle(xOffset, yOffset, availableWidth, availableHeight));
        area.subtract(new Area(this._rectangle));
        g.setColor(new Color(255, 255, 255, 128));
        g2d.fill(area);
        Color oldcolor = g.getColor();
        g.setColor(this._selectionBorder);
        g.drawRect(this._rectangle.x, this._rectangle.y, this._rectangle.width, this._rectangle.height);
        g.setColor(oldcolor);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._image == null || this._rectangle == null) {
            return new Dimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this._image.getWidth(null) + insets.left + insets.right, this._image.getHeight(null) + insets.top + insets.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        this._viewComponent = this._scrollPane.getViewport().getView();
        if (this._viewComponent == null) {
            return;
        }
        int maxSize = Math.max(400, Math.max(this._scrollPane.getWidth(), this._scrollPane.getHeight()) / 2);
        double width = this._viewComponent.getWidth();
        if (width == 0.0) {
            return;
        }
        double height = this._viewComponent.getHeight();
        if (height == 0.0) {
            return;
        }
        double scaleX = (double)maxSize / width;
        double scaleY = (double)maxSize / height;
        this._scale = Math.min(scaleX, scaleY);
        this._image = new BufferedImage((int)(width * this._scale), (int)(height * this._scale), 1);
        Graphics2D g = this._image.createGraphics();
        g.scale(this._scale, this._scale);
        boolean wasDoubleBuffered = this._viewComponent.isDoubleBuffered();
        try {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(false);
            }
            this._viewComponent.paint(g);
        }
        finally {
            if (this._viewComponent instanceof JComponent) {
                ((JComponent)this._viewComponent).setDoubleBuffered(wasDoubleBuffered);
            }
            g.dispose();
        }
        this._startRectangle = this._scrollPane.getViewport().getViewRect();
        Insets insets = this.getInsets();
        this._startRectangle.x = (int)(this._scale * (double)this._startRectangle.x + (double)insets.left);
        this._startRectangle.y = (int)(this._scale * (double)this._startRectangle.y + (double)insets.right);
        this._startRectangle.width = (int)((double)this._startRectangle.width * this._scale);
        this._startRectangle.height = (int)((double)this._startRectangle.height * this._scale);
        this._rectangle = this._startRectangle;
        Point centerPoint = new Point(this._rectangle.x + this._rectangle.width / 2, this._rectangle.y + this._rectangle.height / 2);
        this._popupMenu.show(this._owner, -centerPoint.x, -centerPoint.y);
    }

    private void moveRectangle(int aDeltaX, int aDeltaY) {
        if (this._startRectangle == null) {
            return;
        }
        Insets insets = this.getInsets();
        Rectangle newRect = new Rectangle(this._startRectangle);
        newRect.x += aDeltaX;
        newRect.y += aDeltaY;
        newRect.x = Math.min(Math.max(newRect.x, insets.left), this.getWidth() - insets.right - newRect.width);
        newRect.y = Math.min(Math.max(newRect.y, insets.right), this.getHeight() - insets.bottom - newRect.height);
        Rectangle clip = new Rectangle();
        Rectangle.union(this._rectangle, newRect, clip);
        clip.grow(2, 2);
        this._rectangle = newRect;
        this.paintImmediately(clip);
    }

    private void scroll(int aDeltaX, int aDeltaY) {
        JComponent component = (JComponent)this._scrollPane.getViewport().getView();
        Rectangle rect = component.getVisibleRect();
        rect.x += aDeltaX;
        rect.y += aDeltaY;
        component.scrollRectToVisible(rect);
        this._popupMenu.setVisible(false);
    }
}

