/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.ui;

import java.util.*;
import java.nio.charset.Charset;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;

import GoGrinder.SGFController;
import GoGrinder.FileWReadWrite;
import GoGrinder.FileFilters;
import GoGrinder.ProbData;
import GoGrinder.CharsetWorks;

/**
*@author Ruediger Klehn
*/
public class ChangeCharacterSet extends JDialog{
  private ProbData decodeThisProblem;
  private File decodeThisFileF;
  private String decodeThisFile;
  private String useCaption;
  private String useCharset;
  private String[] availCharSetsStrA;
  private JComboBox charSetComBox; // JComboBox(Vector<?> items) so e.g. Set
  private JTextArea testEncodingArea = new JTextArea();
  private String testCharset;
  private boolean completeFolder = false;
  private boolean folderHasCharset = false;
  private boolean fileHasCharset = false;
  private boolean fileHasCharsetInside;
  private JCheckBox applyToFolderCB;
  private boolean isSGF;
  private JLabel labelCurrentlySetForFile;
  private JLabel labelCurrentlySetForFolder;
  private JButton buttonResetForFile;
  private JButton buttonResetForFolder;
  private String charsetForFolder = "";
  private String charsetForFile = "";
  private String charsetInFile = "";
  private String defCharset = GoGrinder.GS.getMyDefaultCharset();
 // private SGFController thisController;
  
  public ChangeCharacterSet(){/*NOTHING*/;}

  public ChangeCharacterSet(ProbData forThisProblem, String caption){ //, SGFController sgfContr
    // thisController = sgfContr;
    decodeThisProblem = forThisProblem;
    useCaption = caption;
    isSGF = true;
    decodeThisFileF = forThisProblem.getFile();
    decodeThisFile = decodeThisFileF.getPath();
    useCharset = decodeThisProblem.charsetW.getCharset(); // or getCharset() ? - the Charset for display?
    testCharset = useCharset;
    
    charsetForFolder = decodeThisProblem.charsetW.readCharsetForFolder();
 //if(GoGrinder.Main.DEBUG7)d.b.g(charsetForFolder);
    folderHasCharset = (charsetForFolder.equals("")) ? false : true;
    
    charsetForFile = decodeThisProblem.charsetW.getCharsetForFile();
    fileHasCharset = (charsetForFile.equals("")) ? false : true;
    
    charsetInFile = decodeThisProblem.charsetW.getCharsetInFile();
    fileHasCharsetInside = decodeThisProblem.charsetW.charsetIsValid;
  }
  
  public ChangeCharacterSet(File forThisFile, String caption){ // used currently for import tags from file
    decodeThisFileF = forThisFile;
    decodeThisFile = decodeThisFileF.getPath();
    useCaption = caption;
    isSGF = false;
    useCharset = defCharset;
    testCharset = defCharset;
  }
  
  public ProbData forProblem(){
    view();
    return decodeThisProblem;
  }
  
  public String forFile(){
    view();
    return useCharset;
  }
  
  private void view(){ // builds the dialog window
    ToolTipManager.sharedInstance().setDismissDelay(10000);
    setTitle(useCaption);
    setModal(true); 
    Container testContainer = getContentPane();
    testContainer.setLayout(new BoxLayout(testContainer, BoxLayout.Y_AXIS));
    Box selectionBox = new Box(BoxLayout.X_AXIS);
    JButton buttonApplySelection = new JButton("Apply");
    applyToFolderCB = new JCheckBox("to complete folder");
    JLabel statusBarShowPath = new JLabel("");
    Box statusBarBox = new Box(BoxLayout.X_AXIS);
    Box textDisplayBox = new Box(BoxLayout.X_AXIS);
    Box closeButtonBox = new Box(BoxLayout.X_AXIS);
    JButton buttonClose = new JButton((isSGF) ? "Cancel" : "Use default");
    String charsetOrder = "<HTML>Order of importance:<br/>"
                         + " * most: set for file<br/>"
                         + " * then: set in file (e.g.\"CA[UTF-8]\")<br/>"
                         + " * nearly least: set for folder<br/>"
                         + " * and least: default decoding (see settings)</HTML>";
    Set<String> availCharSets = new HashSet<String>();
    availCharSets.addAll(Charset.availableCharsets().keySet()); // availableCharsets() gives a SortedMap
    availCharSetsStrA = availCharSets.toArray(new String [availCharSets.size()]);
    Arrays.sort(availCharSetsStrA); 
    // we could have some presets: + 1 reset view, + 1 local default (OS) (= jvm default), 
    //                             + 1 UTF-8, + 3 user-defined und im menu [x]
    
    charSetComBox = new JComboBox (availCharSetsStrA);
    charSetComBox.setSelectedItem(testCharset);
    charSetComBox.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent e) {
        testCharset = availCharSetsStrA[charSetComBox.getSelectedIndex()];
        onTestCharSetSelected();
      }
    });
    Dimension dim2 = new Dimension(150,30);
    charSetComBox.setMaximumSize(dim2);
    charSetComBox.setToolTipText(charsetOrder);
    selectionBox.add(charSetComBox, BorderLayout.WEST);
    selectionBox.add(Box.createHorizontalStrut(3));

    buttonApplySelection.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent e) {
        if(isSGF) onApplyCharsetSGF();
        else onApplyCharsetFile();
      }
    });
    if(isSGF){
      buttonApplySelection.setToolTipText(charsetOrder);
    }
    selectionBox.add(buttonApplySelection);

    applyToFolderCB.setSelected(false);
    applyToFolderCB.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent e) {
        onApplyToFolder(); // toggles
      }
    });
    if(isSGF)
      selectionBox.add(applyToFolderCB);
      
    selectionBox.add(Box.createHorizontalStrut(10));
    if(isSGF){
      ActionListener resetForFolderListener = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onResetCharsetForFolder();
        }
      };
      buttonResetForFolder = new JButton("Reset folder setting");
      buttonResetForFolder.addActionListener(resetForFolderListener);
      selectionBox.add(buttonResetForFolder);
      selectionBox.add(Box.createHorizontalStrut(3));
      labelCurrentlySetForFolder = new JLabel();
      if(folderHasCharset){
        displayResetFolder();
      }
      else {
        buttonResetForFolder.setEnabled(false);
        labelCurrentlySetForFolder.setText("not set");
        labelCurrentlySetForFolder.setEnabled(false);
      }
      selectionBox.add(labelCurrentlySetForFolder);
      selectionBox.add(Box.createHorizontalStrut(10));
    }
    
    if(isSGF){
      ActionListener resetForFileListener = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onResetCharsetForFile();
        }
      };
      buttonResetForFile = new JButton("Reset file setting");
      buttonResetForFile.addActionListener(resetForFileListener);
      selectionBox.add(buttonResetForFile);

      selectionBox.add(Box.createHorizontalStrut(3));

      labelCurrentlySetForFile = new JLabel();
      if(fileHasCharset){
        displayResetFile();
      }
      else {
        buttonResetForFile.setEnabled(false);
        labelCurrentlySetForFile.setText("not set");
        labelCurrentlySetForFile.setEnabled(false);
      }

      selectionBox.add(labelCurrentlySetForFile);
      selectionBox.add(Box.createHorizontalStrut(10));
    }
    
    if(isSGF){
      JLabel labelCharsetInFile = new JLabel();
      if(fileHasCharsetInside){
        labelCharsetInFile.setText("Set by Sgf: " + charsetInFile);
        labelCharsetInFile.setEnabled(true);
      }
      else{
        labelCharsetInFile.setText("Set by Sgf: none");
        labelCharsetInFile.setEnabled(false);
        labelCharsetInFile.setToolTipText("none or invalid");
      }
      selectionBox.add(labelCharsetInFile);
      selectionBox.add(Box.createHorizontalStrut(10));
    }

    
    testContainer.add(selectionBox);
    statusBarShowPath.setText(" " + decodeThisFile);
    statusBarBox.add(statusBarShowPath);
    statusBarBox.add(Box.createHorizontalGlue());
    testContainer.add(statusBarBox);

    testEncodingArea.setLineWrap(true);
    testEncodingArea.setWrapStyleWord(true);
    testEncodingArea.setEditable(false);
    
    JScrollPane scrollPane = new JScrollPane(testEncodingArea,
                                             JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                                             JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS) {
      public Dimension getPreferredSize() {
          Dimension d = super.getPreferredSize();
          d.setSize(800, 200);
          return d;
      }
    };
    displayText();
    textDisplayBox.add(scrollPane);
    testContainer.add(textDisplayBox);
    
    ActionListener closeListener = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        close();
      }
    };
    buttonClose.addActionListener(closeListener);
    buttonClose.registerKeyboardAction(closeListener, 
                             KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
                             JComponent.WHEN_IN_FOCUSED_WINDOW);
    
    closeButtonBox.add(buttonClose);
    
    testContainer.add(closeButtonBox);
    pack();
    setLocation(200,200);
    getRootPane().setDefaultButton(buttonClose);
    buttonClose.requestFocusInWindow();
    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE); 
    setVisible(true);
    toFront();
  }

  private void onApplyToFolder(){ // "All xy files..."
    int countOfFiles = 0;
    File[] fList = decodeThisFileF.getParentFile().listFiles();
    for (int i=0; i<fList.length; i++){
      if (!fList[i].isDirectory() && fList[i].toString().toLowerCase().endsWith(".sgf")) countOfFiles++;
    }
    // int countOfFiles = decodeThisFileF.getParentFile().listFiles(GoGrinder.FileFilters.sgfFiles).length;
    
    String msg = "All " + countOfFiles + " files of the current folder will be displayed with the chosen decoding. \n"
               + "Remark: \"complete folder\" will not apply to subfolders of \n"
               + decodeThisFileF.getParent() + "\n"
               + "and: if the decoding is set in the file (CA[...]), a differing decoding \n"
               + "must be set explicitly for that file.";
    if(folderHasCharset) msg = msg + "\n\nDecoding for the folder is already set to " + charsetForFolder
                                   + "\nYou are going to overwrite that!";
        
    if(applyToFolderCB.isSelected()) JOptionPane.showMessageDialog(null, msg);
  }

  private void onApplyCharsetFile(){
    useCharset = testCharset;
    close();
  }

  private void onApplyCharsetSGF(){
      if (applyToFolderCB.isSelected()){// creates/overwrites a file in that problem's folder "DECODEWITH", content = charset
        decodeThisProblem.charsetW.setCharsetForFolder(testCharset); // write file for folder in stats
        CharsetWorks.foldersCharsetChanged = true;
      }
      else if (!testCharset.equals(charsetInFile)){
          decodeThisProblem.charsetW.setCharsetForFile(testCharset);
          decodeThisProblem.charsetW.filesCharsetChanged = true;
      }
    close(); // just nothing more happens, when charset not changed and forFolder is not selected
  }
  
  private void close(){
    ToolTipManager.sharedInstance().setDismissDelay(4000);
    dispose();
  }
  
  private void displayResetFile(){
    labelCurrentlySetForFile.setText("(Currently: " + useCharset + ")");
    labelCurrentlySetForFile.setEnabled(true);
    buttonResetForFile.setEnabled(true);
  }
  
  private void displayResetFolder(){
    //charsetForFolder = decodeThisProblem.charsetW.readCharsetForFolder(); // testCharset;
    labelCurrentlySetForFolder.setText("(Currently: " + charsetForFolder + ")");
    labelCurrentlySetForFolder.setEnabled(true);
    buttonResetForFolder.setEnabled(true);
  }
  
  private void onResetCharsetForFile(){ // + update test frame, + update label
    decodeThisProblem.charsetW.resetCharsetForFile();
    labelCurrentlySetForFile.setText("not set");
    labelCurrentlySetForFile.setEnabled(false);
    buttonResetForFile.setEnabled(false);
    testCharset = decodeThisProblem.charsetW.getCharset();
    charSetComBox.setSelectedItem(testCharset);
    decodeThisProblem.charsetW.filesCharsetChanged = true;
    testCharset = decodeThisProblem.charsetW.getCharset();
    fileHasCharset = false;
    displayText();
  } 
  
  private void onResetCharsetForFolder(){
    decodeThisProblem.charsetW.resetCharsetForFolder();
    labelCurrentlySetForFolder.setText("not set");
    labelCurrentlySetForFolder.setEnabled(false);
    buttonResetForFolder.setEnabled(false);
    CharsetWorks.foldersCharsetChanged = true;
    charsetForFolder = "";
    CharsetWorks.charsetForFolder = "";
    folderHasCharset = false;
    testCharset = decodeThisProblem.charsetW.getCharset();
    displayText();
  }
  
  private void displayText(){ // warum kommen wir bei Fensteraufbau 2x hier durch??
 // decodeThisProblem.charsetW.toString(); // WARUM WIRD DAS SO COMPILIERT??? (und ausgefhrt)
 //d.b.g(decodeThisProblem.charsetW.toString());
    String textWithNewEncoding = "";
    StringBuffer textWithNewEncodingStrB = new StringBuffer(new Long(decodeThisFileF.length()).intValue() );
    if(isSGF){
      if(testCharset.equals("")){
        testCharset = defCharset;
      }
      charSetComBox.setSelectedItem(testCharset);
      textWithNewEncoding = FileWReadWrite.readFileStrCharset(decodeThisFileF, testCharset);
    }
    else{
      String[] tagsWithNewEncoding;
      tagsWithNewEncoding = FileWReadWrite.readFileLines(decodeThisFileF, testCharset);
      for (int i = 0; i < tagsWithNewEncoding.length; i++)
        textWithNewEncodingStrB.append(tagsWithNewEncoding[i] + "\n"); 
      textWithNewEncoding = textWithNewEncodingStrB.toString();
    }
    testEncodingArea.selectAll();
    testEncodingArea.replaceSelection(textWithNewEncoding);
    testEncodingArea.setCaretPosition(0);
    testEncodingArea.setToolTipText("<HTML>Displayed with characterset: " + testCharset 
                                  + "<BR>If part or all of the text is displayed wrong"
                                  + "<BR>(\"Mojibake\"), try e.g. \"UTF-8\","
                                  + "<BR>\"windows-###\", \"x-MacXyz\" etc."
                                  + "<BR>(### stands for a number," 
                                  + "<BR>Xyz for something like Roman or Hebrew).</HTML>");
  }

  private void onTestCharSetSelected(){ // possibly coming more here later:
    // I would like to redecode the sgf without new reading the file
    // e.g. when the file content is saved in a byte buffer and decoded from that)
    displayText();
  }
}