/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class JProxy {
    static final Map<Object, Entry> table = new WeakHashMap<Object, Entry>();
    private static final Primitive _JNEW_PROXY = new Primitive("%jnew-proxy", Lisp.PACKAGE_JAVA, false, "interface &rest method-names-and-defs"){

        @Override
        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 3 || length % 2 != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this));
            }
            HashMap<String, Function> lispDefinedMethods = new HashMap<String, Function>();
            for (int i = 1; i < length; i += 2) {
                lispDefinedMethods.put(args[i].getStringValue(), (Function)args[i + 1]);
            }
            Class iface = (Class)args[0].javaInstance();
            Object proxy = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new LispHandler(table));
            table.put(proxy, new Entry(iface, lispDefinedMethods));
            return new JavaObject(proxy);
        }
    };
    static final Map<Object, LispObject> proxyMap = new WeakHashMap<Object, LispObject>();
    private static final Primitive _JMAKE_INVOCATION_HANDLER = new Primitive("%jmake-invocation-handler", Lisp.PACKAGE_JAVA, false, "function"){

        @Override
        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length != 1) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 1));
            }
            if (!(args[0] instanceof Function)) {
                return Lisp.type_error(args[0], Symbol.FUNCTION);
            }
            return new JavaObject(new LispInvocationHandler((Function)args[0]));
        }
    };
    private static final Primitive _JMAKE_PROXY = new Primitive("%jmake-proxy", Lisp.PACKAGE_JAVA, false, "interfaces invocation-handler"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length != 3) {
                return Lisp.error(new WrongNumberOfArgumentsException(this, 3));
            }
            if (!(args[0] instanceof Cons)) {
                return Lisp.type_error(args[0], Symbol.CONS);
            }
            Class[] ifaces = new Class[args[0].length()];
            LispObject ifList = args[0];
            for (int i = 0; i < ifaces.length; ++i) {
                ifaces[i] = (Class)ifList.car().javaInstance(Class.class);
                ifList = ifList.cdr();
            }
            InvocationHandler invocationHandler = (InvocationHandler)((JavaObject)args[1]).javaInstance(InvocationHandler.class);
            Object proxy = Proxy.newProxyInstance(JavaClassLoader.getCurrentClassLoader(), ifaces, invocationHandler);
            Map<Object, LispObject> map = proxyMap;
            synchronized (map) {
                proxyMap.put(proxy, args[2]);
            }
            return new JavaObject(proxy);
        }
    };

    static LispObject toLispObject(Object obj) {
        return obj instanceof LispObject ? (LispObject)obj : new JavaObject(obj);
    }

    public static class LispInvocationHandler
    implements InvocationHandler {
        private Function function;
        private static Method hashCodeMethod;
        private static Method equalsMethod;
        private static Method toStringMethod;

        public LispInvocationHandler(Function function) {
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (hashCodeMethod.equals(method)) {
                return System.identityHashCode(proxy);
            }
            if (equalsMethod.equals(method)) {
                return proxy == args[0];
            }
            if (toStringMethod.equals(method)) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
            }
            if (args == null) {
                args = new Object[]{};
            }
            LispObject lispArgs = Lisp.NIL;
            Map<Object, LispObject> map = proxyMap;
            synchronized (map) {
                lispArgs = lispArgs.push(JProxy.toLispObject(proxyMap.get(proxy)));
            }
            lispArgs = lispArgs.push(new SimpleString(method.getName()));
            for (int i = 0; i < args.length; ++i) {
                lispArgs = lispArgs.push(JProxy.toLispObject(args[i]));
            }
            Object retVal = LispThread.currentThread().execute(Symbol.APPLY, this.function, lispArgs.reverse()).javaInstance();
            return retVal;
        }

        static {
            try {
                hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
                equalsMethod = Object.class.getMethod("equals", Object.class);
                toStringMethod = Object.class.getMethod("toString", new Class[0]);
            }
            catch (Exception e) {
                throw new Error("Something got horribly wrong - can't get a method from Object.class", e);
            }
        }
    }

    private static class Entry {
        Class iface;
        Map lispDefinedMethods;

        public Entry(Class iface, Map lispDefinedMethods) {
            this.iface = iface;
            this.lispDefinedMethods = lispDefinedMethods;
        }

        public Function getLispMethod(String methodName) {
            if (this.lispDefinedMethods.containsKey(methodName)) {
                return (Function)this.lispDefinedMethods.get(methodName);
            }
            return null;
        }
    }

    private static class LispHandler
    implements InvocationHandler {
        Map table;

        LispHandler(Map table) {
            this.table = table;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Entry entry;
            Function f;
            String methodName = method.getName();
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("toString")) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
            }
            if (this.table.containsKey(proxy) && (f = (entry = (Entry)this.table.get(proxy)).getLispMethod(methodName)) != null) {
                LispObject lispArgs = Lisp.NIL;
                if (args != null) {
                    for (int i = args.length - 1; 0 <= i; --i) {
                        lispArgs = lispArgs.push(new JavaObject(args[i]));
                    }
                }
                LispObject result = Lisp.evalCall(f, lispArgs, new Environment(), LispThread.currentThread());
                return method.getReturnType() == Void.TYPE ? null : result.javaInstance();
            }
            return null;
        }
    }
}

