/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class FloatList {
    public static final int DEFAULT_INIT_CAPACITY = 10;
    private int size;
    private float[] values;

    public FloatList() {
        this(10);
    }

    public FloatList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.size = 0;
        this.values = new float[n];
    }

    public void add(float f) {
        if (this.size == this.values.length) {
            int n = this.values.length * 3 / 2 + 1;
            this.values = Arrays.copyOf(this.values, n);
        }
        this.values[this.size++] = f;
    }

    public void addToElement(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        this.values[n2] = this.values[n2] + f;
    }

    public float get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.values[n];
    }

    public float set(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        float f2 = this.values[n];
        this.values[n] = f;
        return f2;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public float[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.values, this.size));
    }
}

