/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.diylc.components.AbstractSchematicLeadedSymbol;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Current;
import org.diylc.core.measures.Inductance;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Inductor (schematic symbol)", author="Branislav Stojkovic", category="Schematics", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="L", description="Inductor schematic symbol", zOrder=4.0)
public class InductorSymbol
extends AbstractSchematicLeadedSymbol<Inductance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_LENGTH = new Size(Double.valueOf(0.3), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.08), SizeUnit.in);
    private Inductance value = null;
    private Current current = null;
    private Resistance resistance = null;
    private boolean core = false;

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Inductance getValue() {
        return this.value;
    }

    public void setValue(Inductance value) {
        this.value = value;
    }

    @EditableProperty
    public Current getCurrent() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    @EditableProperty
    public Resistance getResistance() {
        return this.resistance;
    }

    public void setResistance(Resistance resistance) {
        this.resistance = resistance;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getCurrent() == null ? "" : " " + this.getCurrent().toString());
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR);
        g2d.drawLine(0, height / 2, width / 8, height / 2);
        g2d.drawLine(width * 7 / 8, height / 2, width, height / 2);
        g2d.setColor(COLOR);
        GeneralPath polyline = new GeneralPath();
        polyline.moveTo(width / 8, height / 2);
        polyline.curveTo(width / 8, height / 4, width * 3 / 8, height / 4, width * 3 / 8, height / 2);
        polyline.curveTo(width * 3 / 8, height / 4, width * 5 / 8, height / 4, width * 5 / 8, height / 2);
        polyline.curveTo(width * 5 / 8, height / 4, width * 7 / 8, height / 4, width * 7 / 8, height / 2);
        polyline.moveTo(width / 8, height * 6 / 10);
        polyline.lineTo(width * 7 / 8, height * 6 / 10);
        polyline.moveTo(width / 8, height * 7 / 10);
        polyline.lineTo(width * 7 / 8, height * 7 / 10);
        g2d.draw(polyline);
    }

    protected Size getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    protected Size getDefaultLength() {
        return DEFAULT_LENGTH;
    }

    protected Shape getBodyShape() {
        GeneralPath polyline = new GeneralPath();
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        double d = length / 10.0;
        polyline.moveTo(0.0, width / 2.0);
        polyline.curveTo(0.0, 0.0, 2.0 * d, 0.0, 2.0 * d, width / 2.0);
        polyline.curveTo(2.0 * d, 0.0, 4.0 * d, 0.0, 4.0 * d, width / 2.0);
        polyline.curveTo(4.0 * d, 0.0, 6.0 * d, 0.0, 6.0 * d, width / 2.0);
        polyline.curveTo(6.0 * d, 0.0, 8.0 * d, 0.0, 8.0 * d, width / 2.0);
        polyline.curveTo(8.0 * d, 0.0, 10.0 * d, 0.0, 10.0 * d, width / 2.0);
        if (this.core) {
            polyline.moveTo(0.0, width * 3.0 / 4.0);
            polyline.lineTo(length, width * 3.0 / 4.0);
            polyline.moveTo(0.0, width * 7.0 / 8.0);
            polyline.lineTo(length, width * 7.0 / 8.0);
        }
        return polyline;
    }

    protected boolean useShapeRectAsPosition() {
        return false;
    }

    @EditableProperty
    public boolean getCore() {
        return this.core;
    }

    public void setCore(boolean core) {
        this.core = core;
    }
}

