/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestWatchServiceAction
extends WatcherRestHandler {
    private static final Logger logger = LogManager.getLogger(RestWatchServiceAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    public RestWatchServiceAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_restart", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/_restart", deprecationLogger);
        StartRestHandler startRestHandler = new StartRestHandler(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_start", (RestHandler)startRestHandler, RestRequest.Method.PUT, "/_watcher/_start", deprecationLogger);
        controller.registerHandler(RestRequest.Method.POST, "/_watcher/_start", (RestHandler)startRestHandler);
        StopRestHandler stopRestHandler = new StopRestHandler(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/_stop", (RestHandler)stopRestHandler, RestRequest.Method.PUT, "/_watcher/_stop", deprecationLogger);
        controller.registerHandler(RestRequest.Method.POST, "/_watcher/_stop", (RestHandler)stopRestHandler);
    }

    public String getName() {
        return "xpack_watcher_service_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
        return channel -> client.watcherService(new WatcherServiceRequest().stop(), ActionListener.wrap(stopResponse -> client.watcherService(new WatcherServiceRequest().start(), (ActionListener)new RestToXContentListener(channel)), e -> {
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed((Throwable)e);
                logger.error("failed to send failure response", (Throwable)inner);
            }
        }));
    }

    private static class StopRestHandler
    extends WatcherRestHandler {
        StopRestHandler(Settings settings) {
            super(settings);
        }

        public String getName() {
            return "xpack_watcher_stop_service_action";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
            return channel -> client.watcherService(new WatcherServiceRequest().stop(), (ActionListener)new RestToXContentListener(channel));
        }
    }

    private static class StartRestHandler
    extends WatcherRestHandler {
        StartRestHandler(Settings settings) {
            super(settings);
        }

        public String getName() {
            return "xpack_watcher_start_service_action";
        }

        @Override
        public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
            return channel -> client.watcherService(new WatcherServiceRequest().start(), (ActionListener)new RestToXContentListener(channel));
        }
    }
}

