/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPReportBlock;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPRRPacket
extends RTCPPacket {
    int ssrc;
    RTCPReportBlock[] reports;

    RTCPRRPacket(RTCPPacket parent) {
        super(parent);
        this.type = 201;
    }

    RTCPRRPacket(int ssrc, RTCPReportBlock[] reports) {
        this.ssrc = ssrc;
        this.reports = reports;
        if (reports.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
    }

    public String toString() {
        return "\tRTCP RR (receiver report) packet for sync source " + this.ssrc + ":\n" + RTCPReportBlock.toString(this.reports);
    }

    public int calcLength() {
        return 8 + this.reports.length * 24;
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.reports.length);
        out.writeByte(201);
        out.writeShort(1 + this.reports.length * 6);
        out.writeInt(this.ssrc);
        int i2 = 0;
        while (i2 < this.reports.length) {
            out.writeInt(this.reports[i2].ssrc);
            out.writeInt((this.reports[i2].packetslost & 0xFFFFFF) + (this.reports[i2].fractionlost << 24));
            out.writeInt((int)this.reports[i2].lastseq);
            out.writeInt(this.reports[i2].jitter);
            out.writeInt((int)this.reports[i2].lsr);
            out.writeInt((int)this.reports[i2].dlsr);
            ++i2;
        }
    }
}

