/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.processor.ProcessorContext;

class KTableKTableLeftJoinValueGetter<K1, K2, V1, V2, R>
implements KTableValueGetter<K1, R> {
    private final KTableValueGetter<K1, V1> valueGetter1;
    private final KTableValueGetter<K2, V2> valueGetter2;
    private final ValueJoiner<V1, V2, R> joiner;
    private final KeyValueMapper<K1, V1, K2> keyMapper;

    KTableKTableLeftJoinValueGetter(KTableValueGetter<K1, V1> valueGetter1, KTableValueGetter<K2, V2> valueGetter2, ValueJoiner<V1, V2, R> joiner, KeyValueMapper<K1, V1, K2> keyMapper) {
        this.valueGetter1 = valueGetter1;
        this.valueGetter2 = valueGetter2;
        this.joiner = joiner;
        this.keyMapper = keyMapper;
    }

    @Override
    public void init(ProcessorContext context) {
        this.valueGetter1.init(context);
        this.valueGetter2.init(context);
    }

    @Override
    public R get(K1 key) {
        V1 value1 = this.valueGetter1.get(key);
        if (value1 != null) {
            V2 value2 = this.valueGetter2.get(this.keyMapper.apply(key, value1));
            return this.joiner.apply(value1, value2);
        }
        return null;
    }
}

