/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.util.ArrayList;
import java.util.List;

public class Summary {
    private final List<Fragment> fragments = new ArrayList<Fragment>();
    private static final Fragment[] FRAGMENT_PROTO = new Fragment[0];

    public static String htmlize(String q) {
        StringBuilder sb = new StringBuilder(q.length() * 2);
        for (int i = 0; i < q.length(); ++i) {
            char c = q.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void add(Fragment fragment) {
        this.fragments.add(fragment);
    }

    public Fragment[] getFragments() {
        return this.fragments.toArray(FRAGMENT_PROTO);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.fragments.size(); ++i) {
            buffer.append(this.fragments.get(i));
        }
        return buffer.toString();
    }

    public static class Ellipsis
    extends Fragment {
        public Ellipsis() {
            super(" ... ");
        }

        @Override
        public boolean isEllipsis() {
            return true;
        }

        @Override
        public String toString() {
            return "<b> ... </b>";
        }
    }

    public static class Highlight
    extends Fragment {
        public Highlight(String text) {
            super(text);
        }

        @Override
        public boolean isHighlight() {
            return true;
        }

        @Override
        public String toString() {
            return "<b>" + super.toString() + "</b>";
        }
    }

    public static class Fragment {
        private final String text;

        public Fragment(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public boolean isHighlight() {
            return false;
        }

        public boolean isEllipsis() {
            return false;
        }

        public String toString() {
            return Summary.htmlize(this.text);
        }
    }
}

